/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.rocketplatform.client.generated.PlayerModpackServerWorld;
import net.rocketplatform.client.generated.PlayerModpackServerWorldBackup;
import net.rocketplatform.client.generated.PlayerModpackServerWorldBackupsList;
import net.rocketplatform.client.generated.PlayerModpackServerWorldsList;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class BackupEntryLoader
extends ListEntryLoader {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();

    public BackupEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        if (storage == null) {
            RocketClientMod.getLogger().warn("No storage provided for player list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        if (!storage.contains("gameServerId")) {
            RocketClientMod.getLogger().warn("No game server ID provided for backup list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        if (!storage.contains("selectedWorldId")) {
            RocketClientMod.getLogger().warn("No world ID provided for backup list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        String gameServerId = (String)storage.retrieve("gameServerId");
        int worldId = (Integer)storage.retrieve("selectedWorldId");
        return ((CompletableFuture)((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getPlayerServerWorldBackups(gameServerId))).thenApply(server -> {
            PlayerModpackServerWorldsList serverWorlds = server.getWorlds();
            if (serverWorlds == null) {
                return List.of();
            }
            PlayerModpackServerWorld world = null;
            for (PlayerModpackServerWorld nextWorld : serverWorlds.getWorlds()) {
                if (nextWorld.getWorldId() == null || nextWorld.getWorldId() != worldId) continue;
                world = nextWorld;
                break;
            }
            if (world == null) {
                RocketClientMod.getLogger().warn("No world found for ID {} when loading world backups.", (Object)worldId);
                return List.of();
            }
            PlayerModpackServerWorldBackupsList worldBackups = world.getBackups();
            if (worldBackups == null || worldBackups.getBackups() == null || worldBackups.getBackups().isEmpty()) {
                return List.of();
            }
            List<PlayerModpackServerWorldBackup> backups = worldBackups.getBackups().stream().filter(backup -> backup.getBackupId() != null).sorted((a, b) -> Long.compare(b.getTakenAt(), a.getTakenAt())).toList();
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            int i = 1;
            for (PlayerModpackServerWorldBackup backup2 : backups) {
                if (backup2.getBackupId() == null) continue;
                VariableStorage backupStorage = new VariableStorage();
                backupStorage.store("backupNumber", i++);
                backupStorage.store("backupId", backup2.getBackupId());
                backupStorage.store("backupDone", backup2.getDone() != null && backup2.getDone() != false);
                backupStorage.store("backupDoneSuccessfully", backup2.getDoneSuccessfully() != null && backup2.getDoneSuccessfully() != false);
                backupStorage.store("backupTakenAt", DATE_FORMAT.format(backup2.getTakenAt() * 1000L));
                List<ElementTemplate<?>> elements = BackupEntryLoader.processElements(entryTemplate, backupStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), backupStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, backupStorage));
            }
            return entries;
        })).exceptionally(e -> {
            RocketClientMod.getLogger().error("Failed to load backup entries", e);
            return List.of();
        });
    }
}

