/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.neoforge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.config.RocketClientModConfig;
import net.rocketplatform.game.client.mod.neoforge.ui.handler.TitleScreenHandler;
import net.rocketplatform.game.client.mod.platform.ModPlatform;

@Mod(value="rgp_client")
public class RocketClientModNeoForge {
    private final RocketClientMod mod;

    public RocketClientModNeoForge(ModContainer modContainer, IEventBus eventBus) {
        modContainer.registerConfig(ModConfig.Type.COMMON, RocketClientModConfig.SPEC);
        this.mod = RocketClientMod.load(ModPlatform.FORGE, FMLPaths.CONFIGDIR.get().resolve("rgp_client"));
        NeoForge.EVENT_BUS.addListener(TitleScreenHandler::onTitleScreenInit);
        NeoForge.EVENT_BUS.addListener(this::onEntityJoinLevel);
        NeoForge.EVENT_BUS.addListener(this::onEntityLeaveLevel);
    }

    private void onEntityJoinLevel(EntityJoinLevelEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (event.getEntity().equals((Object)player)) {
            this.mod.onSessionActive();
        }
    }

    private void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (event.getEntity().equals((Object)player)) {
            this.mod.onSessionInactive();
        }
    }
}

