/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.datacomponents;

import de.maxhenkel.easypiglins.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easypiglins.items.ModItems;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class PiglinBlockEntityData {
    public static final StreamCodec<RegistryFriendlyByteBuf, PiglinBlockEntityData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PiglinBlockEntityData>(){

        public PiglinBlockEntityData decode(RegistryFriendlyByteBuf buf) {
            return new PiglinBlockEntityData(buf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf buf, PiglinBlockEntityData be) {
            buf.writeNbt((Tag)be.nbt);
        }
    };
    private WeakReference<FakeWorldTileentity> cache = new WeakReference<Object>(null);
    private WeakReference<FakeWorldTileentity> emptyCache = new WeakReference<Object>(null);
    private final CompoundTag nbt;

    private PiglinBlockEntityData(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public CompoundTag copy() {
        return this.nbt.copy();
    }

    public static PiglinBlockEntityData of(CompoundTag nbt) {
        return new PiglinBlockEntityData(nbt.copy());
    }

    @Nullable
    public static PiglinBlockEntityData get(ItemStack stack) {
        return (PiglinBlockEntityData)stack.get(ModItems.BLOCK_ENTITY_DATA_COMPONENT);
    }

    public <T extends FakeWorldTileentity> T getBlockEntity(HolderLookup.Provider provider, @Nullable Level level, Supplier<T> blockEntitySupplier) {
        if (level == null) {
            FakeWorldTileentity te = (FakeWorldTileentity)((Object)this.emptyCache.get());
            if (te == null) {
                te = (FakeWorldTileentity)((Object)blockEntitySupplier.get());
                this.emptyCache = new WeakReference<FakeWorldTileentity>(te);
            }
            return (T)((Object)te);
        }
        FakeWorldTileentity te = (FakeWorldTileentity)((Object)this.cache.get());
        if (te == null) {
            te = (FakeWorldTileentity)((Object)blockEntitySupplier.get());
            te.setFakeWorld(level);
            te.loadCustomOnly(this.nbt, provider);
            this.cache = new WeakReference<FakeWorldTileentity>(te);
        }
        return (T)((Object)te);
    }

    public static <T extends FakeWorldTileentity> T getAndStoreBlockEntity(ItemStack stack, HolderLookup.Provider provider, @Nullable Level level, Supplier<T> blockEntitySupplier) {
        PiglinBlockEntityData data = PiglinBlockEntityData.get(stack);
        if (data == null) {
            CustomData beData = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
            data = new PiglinBlockEntityData(beData.copyTag());
            stack.set(ModItems.BLOCK_ENTITY_DATA_COMPONENT, (Object)data);
        }
        return data.getBlockEntity(provider, level, blockEntitySupplier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiglinBlockEntityData be = (PiglinBlockEntityData)o;
        return Objects.equals(this.nbt, be.nbt);
    }

    public int hashCode() {
        return Objects.hashCode(this.nbt);
    }
}

