/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.util.ModUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public final class PyramidProjectorMode
implements ProjectorMode {
    @Override
    public Set<Vec3> getExteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        int xStretch = posScale.getX() + negScale.getX();
        int yStretch = posScale.getY() + negScale.getY();
        int zStretch = posScale.getZ() + negScale.getZ();
        Vec3 translation = new Vec3(0.0, (double)(-negScale.getY()), 0.0);
        int inverseThickness = 8;
        for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
            for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
                for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                    double yTest = y / (float)yStretch * (float)inverseThickness;
                    double xzPositivePlane = (1.0f - x / (float)xStretch - z / (float)zStretch) * (float)inverseThickness;
                    double xzNegativePlane = (1.0f + x / (float)xStretch - z / (float)zStretch) * (float)inverseThickness;
                    if (x >= 0.0f && z >= 0.0f && Math.round(xzPositivePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)z).add(translation));
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)(-z)).add(translation));
                    }
                    if (x <= 0.0f && z >= 0.0f && Math.round(xzNegativePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)(-z)).add(translation));
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)z).add(translation));
                    }
                    if (y != 0.0f || !((double)(Math.abs(x) + Math.abs(z)) < (double)(xStretch + yStretch) / 2.0)) continue;
                    fieldBlocks.add(new Vec3((double)x, (double)y, (double)z).add(translation));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vec3> getInteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        BlockPos projectorPos = projector.be().getBlockPos();
        int xStretch = posScale.getX() + negScale.getX();
        int yStretch = posScale.getY() + negScale.getY();
        int zStretch = posScale.getZ() + negScale.getZ();
        Vec3 translation = new Vec3(0.0, -0.4, 0.0);
        for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
            for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
                    Vec3 position = new Vec3((double)x, (double)y, (double)z).add(translation);
                    if (!this.isInField(projector, position.add((double)projectorPos.getX(), (double)projectorPos.getY(), (double)projectorPos.getZ()))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(Projector projector, Vec3 position) {
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        int xStretch = posScale.getX() + negScale.getX();
        int yStretch = posScale.getY() + negScale.getY();
        int zStretch = posScale.getZ() + negScale.getZ();
        BlockPos projectorPos = projector.be().getBlockPos().offset((Vec3i)projector.getTranslation()).offset(0, -negScale.getY(), 0);
        Vec3 relativePosition = position.subtract((double)projectorPos.getX(), (double)projectorPos.getY(), (double)projectorPos.getZ());
        Vec3 relativeRotated = ModUtil.rotateByAngleExact(relativePosition, -projector.getRotationYaw(), -projector.getRotationPitch(), 0.0);
        Vec3 min = Vec3.atLowerCornerOf((Vec3i)negScale.multiply(-1));
        return PyramidProjectorMode.isIn(min, Vec3.atLowerCornerOf((Vec3i)posScale), relativeRotated) && relativeRotated.y() > 0.0 && 1.0 - Math.abs(relativeRotated.x()) / (double)xStretch - Math.abs(relativeRotated.z()) / (double)zStretch > relativeRotated.y() / (double)yStretch;
    }

    private static boolean isIn(Vec3 min, Vec3 max, Vec3 vec) {
        return vec.x() > min.x() && vec.x() < max.x() && vec.y() > min.y() && vec.y() < max.y() && vec.z() > min.z() && vec.z() < max.z();
    }
}

