/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.screen;

import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.TooltipSlot;
import dev.su5ed.mffs.util.inventory.ColoredSlot;
import dev.su5ed.mffs.util.inventory.SlotActive;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import one.util.streamex.StreamEx;

public abstract class BaseScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private final ResourceLocation background;
    private final List<TooltipCoordinate> tooltips = new ArrayList<TooltipCoordinate>();

    public BaseScreen(T menu, Inventory playerInventory, Component title, ResourceLocation background) {
        super(menu, playerInventory, title);
        this.background = background;
        this.imageHeight = 217;
        this.height = 217;
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderFg(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.background, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    /*
     * Unable to fully structure code
     */
    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!this.menu.getCarried().isEmpty() || !((var5_4 = this.hoveredSlot) instanceof TooltipSlot)) ** GOTO lbl-1000
        tooltipSlot = (TooltipSlot)var5_4;
        if (!this.hoveredSlot.hasItem()) {
            guiGraphics.renderComponentTooltip(this.font, tooltipSlot.getTooltips(), mouseX, mouseY);
        } else if (!this.tooltips.isEmpty()) {
            ((StreamEx)StreamEx.of(this.tooltips).filter((Predicate<TooltipCoordinate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$renderTooltip$0(int int dev.su5ed.mffs.screen.BaseScreen$TooltipCoordinate ), (Ldev/su5ed/mffs/screen/BaseScreen$TooltipCoordinate;)Z)((BaseScreen)this, (int)mouseX, (int)mouseY))).forEach((Consumer<TooltipCoordinate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$renderTooltip$1(net.minecraft.client.gui.GuiGraphics int int dev.su5ed.mffs.screen.BaseScreen$TooltipCoordinate ), (Ldev/su5ed/mffs/screen/BaseScreen$TooltipCoordinate;)V)((BaseScreen)this, (GuiGraphics)guiGraphics, (int)mouseX, (int)mouseY));
        }
        this.tooltips.clear();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    public void renderFg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        ColoredSlot colored;
        super.renderSlot(guiGraphics, slot);
        if (slot instanceof ColoredSlot && (colored = (ColoredSlot)slot).shouldTint()) {
            guiGraphics.fill(colored.tintItems() ? RenderType.guiOverlay() : RenderType.gui(), slot.x - 1, slot.y - 1, slot.x + 17, slot.y + 17, colored.getTintColor());
        }
    }

    protected boolean isHovering(Slot slot, double mouseX, double mouseY) {
        SlotActive slotActive;
        return (!(slot instanceof SlotActive) || !(slotActive = (SlotActive)slot).isDisabled()) && super.isHovering(slot, mouseX, mouseY);
    }

    protected void drawWithTooltip(GuiGraphics guiGraphics, float x, float y, int color, String name, Object ... args) {
        this.drawWithTooltip(guiGraphics, x, y, color, (Component)ModUtil.translate("screen", name, args), (Component)ModUtil.translate("screen", name + ".tooltip", new Object[0]));
    }

    protected void drawWithTooltip(GuiGraphics guiGraphics, float x, float y, int color, Component message, Component tooltip) {
        String text = message.getString();
        int width = this.font.width(text);
        Objects.requireNonNull(this.font);
        int height = 9;
        guiGraphics.drawString(this.font, text, (int)x, (int)y, color, false);
        this.tooltips.add(new TooltipCoordinate((int)x, (int)y, width, height, tooltip));
    }

    private /* synthetic */ void lambda$renderTooltip$1(GuiGraphics guiGraphics, int mouseX, int mouseY, TooltipCoordinate coord) {
        guiGraphics.renderComponentTooltip(this.font, List.of(coord.tooltip), mouseX, mouseY);
    }

    private /* synthetic */ boolean lambda$renderTooltip$0(int mouseX, int mouseY, TooltipCoordinate coord) {
        return this.isHovering(coord.x, coord.y, coord.width, coord.height, mouseX, mouseY);
    }

    public record TooltipCoordinate(int x, int y, int width, int height, Component tooltip) {
    }
}

