/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import com.mojang.serialization.Codec;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.DetailRegistry;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.MediaProvider;
import dan200.computercraft.api.network.PacketNetwork;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.BundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.impl.Services;
import dan200.computercraft.impl.upgrades.TurtleToolSpec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface ComputerCraftAPIService {
    public static ComputerCraftAPIService get() {
        ComputerCraftAPIService instance = Instance.INSTANCE;
        return instance == null ? Services.raise(ComputerCraftAPIService.class, Instance.ERROR) : instance;
    }

    public String getInstalledVersion();

    public int createUniqueNumberedSaveDir(MinecraftServer var1, String var2);

    public WritableMount createSaveDirMount(MinecraftServer var1, String var2, long var3);

    @Nullable
    public Mount createResourceMount(MinecraftServer var1, String var2, String var3);

    public void registerGenericSource(GenericSource var1);

    public void registerBundledRedstoneProvider(BundledRedstoneProvider var1);

    public int getBundledRedstoneOutput(Level var1, BlockPos var2, Direction var3);

    public void registerMediaProvider(MediaProvider var1);

    public PacketNetwork getWirelessNetwork(MinecraftServer var1);

    public void registerAPIFactory(ILuaAPIFactory var1);

    public WiredNode createWiredNodeForElement(WiredElement var1);

    public void registerRefuelHandler(TurtleRefuelHandler var1);

    public ResourceKey<Registry<UpgradeType<? extends ITurtleUpgrade>>> turtleUpgradeRegistryId();

    public Codec<ITurtleUpgrade> turtleUpgradeCodec();

    public ResourceKey<Registry<UpgradeType<? extends IPocketUpgrade>>> pocketUpgradeRegistryId();

    public ITurtleUpgrade createTurtleTool(TurtleToolSpec var1);

    public Codec<IPocketUpgrade> pocketUpgradeCodec();

    public DetailRegistry<ItemStack> getItemStackDetailRegistry();

    public DetailRegistry<BlockReference> getBlockInWorldDetailRegistry();

    public static final class Instance {
        @Nullable
        static final ComputerCraftAPIService INSTANCE;
        @Nullable
        static final Throwable ERROR;

        private Instance() {
        }

        static {
            Services.LoadedService<ComputerCraftAPIService> helper = Services.tryLoad(ComputerCraftAPIService.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }
}

