/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SlotwiseItemHandler
implements IItemHandlerModifiable,
Iterable<ItemStack> {
    private final ItemStackHandler rawHandler;
    private final List<IOConstraint> slotConstraints;

    public static SlotwiseItemHandler makeWithGroups(Runnable onChanged, IOConstraintGroup ... constraintGroups) {
        return SlotwiseItemHandler.makeWithGroups(Arrays.asList(constraintGroups), onChanged);
    }

    public static SlotwiseItemHandler onSlotRange(IOConstraint constraint, int min, int count, Runnable onChanged) {
        return SlotwiseItemHandler.makeWithGroups(onChanged, new IOConstraintGroup(IOConstraint.BLOCKED, min), new IOConstraintGroup(IOConstraint.ANY_INPUT, count));
    }

    public static SlotwiseItemHandler makeWithGroups(List<IOConstraintGroup> constraintGroups, Runnable onChanged) {
        ArrayList<IOConstraint> slotConstraints = new ArrayList<IOConstraint>();
        for (IOConstraintGroup group : constraintGroups) {
            for (int i = 0; i < group.slotCount; ++i) {
                slotConstraints.add(group.constraint);
            }
        }
        return new SlotwiseItemHandler(slotConstraints, onChanged);
    }

    public SlotwiseItemHandler(List<IOConstraint> slotConstraints, final Runnable onChanged) {
        this.rawHandler = new ItemStackHandler(this, slotConstraints.size()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                onChanged.run();
            }
        };
        this.slotConstraints = slotConstraints;
    }

    public int getSlots() {
        return this.rawHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.rawHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot >= this.slotConstraints.size() || !this.slotConstraints.get((int)slot).allowInsert.test(stack)) {
            return stack;
        }
        return this.rawHandler.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.slotConstraints.size() || !this.slotConstraints.get(slot).allowExtract()) {
            return ItemStack.EMPTY;
        }
        return this.rawHandler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.rawHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.rawHandler.isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.rawHandler.setStackInSlot(slot, stack);
    }

    public Tag serializeNBT(HolderLookup.Provider provider) {
        return this.rawHandler.serializeNBT(provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.rawHandler.deserializeNBT(provider, nbt);
    }

    public ItemStackHandler getRawHandler() {
        return this.rawHandler;
    }

    @Override
    @Nonnull
    public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            private int slot = 0;

            @Override
            public boolean hasNext() {
                return this.slot < SlotwiseItemHandler.this.getSlots();
            }

            @Override
            public ItemStack next() {
                ItemStack next = SlotwiseItemHandler.this.getStackInSlot(this.slot);
                ++this.slot;
                return next;
            }
        };
    }

    public record IOConstraintGroup(IOConstraint constraint, int slotCount) {
    }

    public record IOConstraint(boolean allowExtract, Predicate<ItemStack> allowInsert) {
        public static final IOConstraint OUTPUT = new IOConstraint(true, $ -> false);
        public static final IOConstraint ANY_INPUT = new IOConstraint(false, $ -> true);
        public static final IOConstraint FLUID_INPUT = IOConstraint.input(Utils::isFluidRelatedItemStack);
        public static final IOConstraint NO_CONSTRAINT = new IOConstraint(true, $ -> true);
        public static final IOConstraint BLOCKED = new IOConstraint(false, $ -> false);

        public static IOConstraint input(Predicate<ItemStack> allow) {
            return new IOConstraint(false, allow);
        }
    }
}

