/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.crafting.PotionHelper;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PotionRecipeGenerators {
    public static final Set<String> BLACKLIST = new HashSet<String>();

    public static List<MixerRecipe> initPotionRecipes() {
        HashMap recipes = new HashMap();
        PotionHelper.applyToAllPotionRecipes((out, in, reagent) -> PotionRecipeGenerators.registerPotionRecipe((Holder<Potion>)out, (Holder<Potion>)in, reagent, recipes));
        return recipes.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<BottlingMachineRecipe> getPotionBottlingRecipes() {
        HashMap<Holder, BottlingMachineRecipe> bottleRecipes = new HashMap<Holder, BottlingMachineRecipe>();
        Function<Holder, BottlingMachineRecipe> toBottleRecipe = potion -> new BottlingMachineRecipe(new TagOutputList(new TagOutput(PotionContents.createItemStack((Item)Items.POTION, (Holder)potion))), IngredientWithSize.of(new ItemStack((ItemLike)Items.GLASS_BOTTLE)), PotionHelper.getFluidTagForType((Holder<Potion>)potion, 250));
        HashMap bulletRecipes = new HashMap();
        Function<Holder, BottlingMachineRecipe> toBulletRecipe = potion -> {
            Item potionBulletItem = BulletHandler.getBulletItem(IEBullets.POTION);
            return new BottlingMachineRecipe(new TagOutputList(new TagOutput(PotionContents.createItemStack((Item)potionBulletItem, (Holder)potion))), new IngredientWithSize(Ingredient.of((ItemLike[])new ItemLike[]{potionBulletItem})), PotionHelper.getFluidTagForType((Holder<Potion>)potion, 250));
        };
        PotionHelper.applyToAllPotionRecipes((out, in, reagent) -> {
            if (!bottleRecipes.containsKey(out)) {
                bottleRecipes.put(out, (BottlingMachineRecipe)toBottleRecipe.apply(out));
            }
            if (!bulletRecipes.containsKey(out)) {
                bulletRecipes.put(out, (BottlingMachineRecipe)toBulletRecipe.apply(out));
            }
        });
        bottleRecipes.put(Potions.WATER, toBottleRecipe.apply(Potions.WATER));
        IELogger.logger.info("Recipes for potions: " + bottleRecipes.keySet().stream().map(h -> ((ResourceKey)h.unwrapKey().orElseThrow()).location().toString()).collect(Collectors.joining(", ")));
        ArrayList<BottlingMachineRecipe> ret = new ArrayList<BottlingMachineRecipe>(bottleRecipes.values());
        ret.addAll(bulletRecipes.values());
        return ret;
    }

    public static void registerPotionRecipe(Holder<Potion> output, Holder<Potion> input, IngredientWithSize reagent, Map<Potion, List<MixerRecipe>> all) {
        ResourceLocation outputID = ((ResourceKey)output.unwrapKey().orElseThrow()).location();
        if (!BLACKLIST.contains(outputID.toString())) {
            List existing = all.computeIfAbsent((Potion)output.value(), p -> new ArrayList());
            MixerRecipe recipe = new MixerRecipe(PotionFluid.getFluidStackForType(Optional.of(output), 1000), PotionHelper.getFluidTagForType(input, 1000), List.of(reagent), 6400);
            existing.add(recipe);
        }
    }
}

