/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.mixin.accessors.PotionBrewingAccess;
import blusunrize.immersiveengineering.mixin.accessors.PotionMixAccess;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PotionHelper {
    public static FluidTagInput getFluidTagForType(Holder<Potion> type, int amount) {
        if (type == Potions.WATER || type == null) {
            return new FluidTagInput((TagKey<Fluid>)FluidTags.WATER, amount);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Potion", ((ResourceKey)type.unwrapKey().orElseThrow()).location().toString());
        return new FluidTagInput(IETags.fluidPotion, amount, DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(type)).build());
    }

    public static void applyToAllPotionRecipes(PotionRecipeProcessor out) {
        PotionBrewing brewingData = ServerLifecycleHooks.getCurrentServer() != null ? ServerLifecycleHooks.getCurrentServer().potionBrewing() : ImmersiveEngineering.proxy.getClientWorld().potionBrewing();
        for (PotionMixAccess<Potion> mixPredicate : ((PotionBrewingAccess)brewingData).getConversions()) {
            if (mixPredicate.getTo() == Potions.MUNDANE || mixPredicate.getTo() == Potions.THICK) continue;
            out.apply(mixPredicate.getTo(), mixPredicate.getFrom(), new IngredientWithSize(mixPredicate.getIngredient()));
        }
        for (IBrewingRecipe recipe : brewingData.getRecipes()) {
            if (!(recipe instanceof BrewingRecipe)) continue;
            BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
            IngredientWithSize ingredient = new IngredientWithSize(brewingRecipe.getIngredient());
            Ingredient input = brewingRecipe.getInput();
            ItemStack output = brewingRecipe.getOutput();
            if (output.getItem() != Items.POTION || input.getItems().length <= 0) continue;
            out.apply(PotionHelper.getPotion(output), PotionHelper.getPotion(input.getItems()[0]), ingredient);
        }
    }

    private static Holder<Potion> getPotion(ItemStack potion) {
        PotionContents potionData = (PotionContents)potion.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return potionData.potion().orElse(Potions.WATER);
    }

    public static interface PotionRecipeProcessor {
        public void apply(Holder<Potion> var1, Holder<Potion> var2, IngredientWithSize var3);
    }
}

