/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidSorterBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IInteractionObjectIE<FluidSorterBlockEntity>,
IFluidPipe,
IEBlockInterfaces.IBlockEntityDrop {
    public byte[] sortWithNBT = new byte[]{1, 1, 1, 1, 1, 1};
    public static final int FILTER_SLOTS_PER_SIDE = 8;
    public FluidStack[][] filters = FluidSorterBlockEntity.makeFilterArray();
    private static Set<BlockPos> usedRouters = null;
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IFluidHandler>> neighborCaps = IEBlockCapabilityCaches.allNeighbors(Capabilities.FluidHandler.BLOCK, this);
    private final EnumMap<Direction, IFluidHandler> insertionHandlers = new EnumMap(Direction.class);

    public FluidSorterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLUID_SORTER.get(), pos, state);
        for (Direction f : DirectionUtils.VALUES) {
            this.insertionHandlers.put(f, new SorterFluidHandler(this, f));
        }
    }

    public int routeFluid(Direction inputSide, FluidStack stack, IFluidHandler.FluidAction doFill) {
        int ret = 0;
        if (!this.level.isClientSide && this.canRoute()) {
            boolean first = this.startRouting();
            Direction[][] validOutputs = this.getValidOutputs(inputSide, stack);
            ret += this.doInsert(stack, validOutputs[0], doFill);
            if (validOutputs[0].length == 0) {
                ret += this.doInsert(stack, validOutputs[1], doFill);
            }
            if (first) {
                usedRouters = null;
            }
        }
        return ret;
    }

    private boolean canRoute() {
        return usedRouters == null || !usedRouters.contains(this.worldPosition);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = usedRouters == null;
        if (first) {
            usedRouters = new HashSet<BlockPos>();
        }
        usedRouters.add(this.worldPosition);
        return first;
    }

    private int doInsert(FluidStack stack, Direction[] sides, IFluidHandler.FluidAction doFill) {
        int ret = 0;
        FluidStack available = stack.copy();
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && available.getAmount() > 0; --lengthFiltered) {
            int rand = ApiUtils.RANDOM.nextInt(lengthFiltered);
            Direction currentSide = sides[rand];
            IFluidHandler fluidOut = this.neighborCaps.get(currentSide).getCapability();
            if (fluidOut != null) {
                int filledHere = fluidOut.fill(available, doFill);
                available.shrink(filledHere);
                ret += filledHere;
            }
            sides[rand] = sides[lengthFiltered - 1];
        }
        return ret;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sortWithNBT.length) {
            return this.sortWithNBT[side] == 1;
        }
        return false;
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public FluidSorterBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<FluidSorterBlockEntity, ?> getContainerType() {
        return IEMenuTypes.FLUID_SORTER;
    }

    public Direction[][] getValidOutputs(Direction inputSide, @Nullable FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.isEmpty()) {
            return new Direction[2][0];
        }
        fluidStack = fluidStack.copyWithAmount(1);
        fluidStack.remove(IEApiDataComponents.FLUID_PRESSURIZED);
        ArrayList<Direction> validFilteredInvOuts = new ArrayList<Direction>(6);
        ArrayList<Direction> validUnfilteredInvOuts = new ArrayList<Direction>(6);
        for (Direction side : Direction.values()) {
            if (side == inputSide || !this.level.hasChunkAt(this.getBlockPos().relative(side))) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (FluidStack filterStack : this.filters[side.ordinal()]) {
                boolean b;
                if (filterStack.isEmpty()) continue;
                unmapped = false;
                boolean bl = b = filterStack.getFluid() == fluidStack.getFluid();
                if (this.doNBT(side.ordinal())) {
                    b &= filterStack.getComponents().equals((Object)fluidStack.getComponents());
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                validFilteredInvOuts.add(side);
                continue;
            }
            if (!unmapped) continue;
            validUnfilteredInvOuts.add(side);
        }
        return new Direction[][]{validFilteredInvOuts.toArray(new Direction[0]), validUnfilteredInvOuts.toArray(new Direction[0])};
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.sortWithNBT = nbt.getByteArray("sortWithNBT");
        for (int side = 0; side < 6; ++side) {
            ListTag filterList = nbt.getList("filter_" + side, 10);
            for (int i = 0; i < filterList.size(); ++i) {
                this.filters[side][i] = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)filterList.getCompound(i));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.putByteArray("sortWithNBT", this.sortWithNBT);
        for (int side = 0; side < 6; ++side) {
            ListTag filterList = new ListTag();
            for (int i = 0; i < this.filters[side].length; ++i) {
                filterList.add((Object)this.filters[side][i].saveOptional(provider));
            }
            nbt.put("filter_" + side, (Tag)filterList);
        }
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        CompoundTag data = new CompoundTag();
        this.writeCustomNBT(data, false, (HolderLookup.Provider)context.getLevel().registryAccess());
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)data));
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        CustomData data = (CustomData)ctx.getItemInHand().get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null) {
            this.readCustomNBT(data.copyTag(), false, (HolderLookup.Provider)ctx.getLevel().registryAccess());
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<FluidSorterBlockEntity> registrar) {
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, facing) -> facing != null ? be.insertionHandlers.get(facing) : null);
    }

    public static FluidStack[][] makeFilterArray() {
        FluidStack[][] filters;
        for (Object[] objectArray : filters = new FluidStack[DirectionUtils.VALUES.length][8]) {
            Arrays.fill(objectArray, FluidStack.EMPTY);
        }
        return filters;
    }

    static class SorterFluidHandler
    implements IFluidHandler {
        FluidSorterBlockEntity tile;
        Direction facing;

        SorterFluidHandler(FluidSorterBlockEntity tile, Direction facing) {
            this.tile = tile;
            this.facing = facing;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty()) {
                return 0;
            }
            return this.tile.routeFluid(this.facing, resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }
    }
}

