/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class TurretGunBlockEntity
extends TurretBlockEntity<TurretGunBlockEntity> {
    public static final int NUM_SLOTS = 2;
    public int cycleRender;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    public boolean expelCasings = false;
    private final IItemHandler itemHandler = new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, false}, new boolean[]{false, true});

    public TurretGunBlockEntity(BlockEntityType<TurretGunBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected double getRange() {
        return 16.0;
    }

    @Override
    protected boolean canActivate() {
        return this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.turret_gun_consumption.get() && !((ItemStack)this.inventory.get(0)).isEmpty();
    }

    @Override
    protected int getChargeupTicks() {
        return 5;
    }

    @Override
    protected int getActiveTicks() {
        return 5;
    }

    @Override
    protected boolean loopActivation() {
        return false;
    }

    @Override
    protected void activate() {
        BulletHandler.IBullet<?> bullet;
        int energy = (Integer)IEServerConfig.MACHINES.turret_gun_consumption.get();
        ItemStack bulletStack = (ItemStack)this.inventory.get(0);
        if (bulletStack.getItem() instanceof BulletItem && this.energyStorage.extractEnergy(energy, true) == energy && (bullet = ((BulletItem)bulletStack.getItem()).getType()) != null && bullet.isValidForTurret()) {
            ItemStack casing = bullet.getCasing(bulletStack);
            if (this.expelCasings || casing.isEmpty() || ((ItemStack)this.inventory.get(1)).isEmpty() || ItemStack.isSameItem((ItemStack)casing, (ItemStack)((ItemStack)this.inventory.get(1))) && ((ItemStack)this.inventory.get(1)).getCount() + casing.getCount() <= ((ItemStack)this.inventory.get(1)).getMaxStackSize()) {
                SoundEvent sound;
                this.energyStorage.extractEnergy(energy, false);
                this.sendRenderPacket();
                Vec3 vec = this.getGunToTargetVec(this.target).normalize();
                int count = bullet.getProjectileCount(null);
                if (count == 1) {
                    this.level.addFreshEntity(this.getBulletEntity(vec, bulletStack));
                } else {
                    for (int i = 0; i < count; ++i) {
                        Vec3 vecDir = vec.add(ApiUtils.RANDOM.nextGaussian() * 0.1, ApiUtils.RANDOM.nextGaussian() * 0.1, ApiUtils.RANDOM.nextGaussian() * 0.1);
                        this.level.addFreshEntity(this.getBulletEntity(vecDir, bulletStack));
                    }
                }
                bulletStack.shrink(1);
                if (bulletStack.getCount() <= 0) {
                    this.inventory.set(0, (Object)ItemStack.EMPTY);
                }
                if (!casing.isEmpty()) {
                    if (this.expelCasings) {
                        double cX = (double)this.getBlockPos().getX() + 0.5;
                        double cY = (double)this.getBlockPos().getY() + 1.375;
                        double cZ = (double)this.getBlockPos().getZ() + 0.5;
                        Vec3 vCasing = vec.yRot(-1.57f);
                        this.level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, cX + vCasing.x, cY + vCasing.y, cZ + vCasing.z, 0.0, 0.0, 0.0);
                        ItemEntity entCasing = new ItemEntity(this.level, cX + vCasing.x, cY + vCasing.y, cZ + vCasing.z, casing.copy());
                        entCasing.setDeltaMovement(0.0, -0.01, 0.0);
                        this.level.addFreshEntity((Entity)entCasing);
                    } else if (((ItemStack)this.inventory.get(1)).isEmpty()) {
                        this.inventory.set(1, (Object)casing.copy());
                    } else {
                        ((ItemStack)this.inventory.get(1)).grow(casing.getCount());
                    }
                }
                if ((sound = bullet.getSound()) == null) {
                    sound = (SoundEvent)IESounds.revolverFire.value();
                }
                this.level.playSound(null, this.getBlockPos(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void sendRenderPacket() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("cycle", true);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new MessageBlockEntitySync(this.getBlockPos(), tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private Entity getBulletEntity(Vec3 vecDir, ItemStack bulletStack) {
        return ((BulletItem)bulletStack.getItem()).createBullet(this.level, null, this.getGunPosition(), vecDir, bulletStack, false);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.getItem() instanceof BulletItem;
        }
        return true;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isDummy() && this.cycleRender > 0) {
            --this.cycleRender;
        }
    }

    @Override
    public void receiveMessageFromServer(CompoundTag message) {
        if (message.contains("cycle")) {
            this.cycleRender = 5;
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        if (!descPacket) {
            this.expelCasings = nbt.getBoolean("expelCasings");
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        if (!descPacket) {
            nbt.putBoolean("expelCasings", this.expelCasings);
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<TurretGunBlockEntity> registrar) {
        TurretBlockEntity.registerCapabilitiesBase(registrar);
        registrar.register(Capabilities.ItemHandler.BLOCK, (be, facing) -> {
            if (!(be.isDummy() || facing != null && facing != Direction.DOWN && facing != be.getFacing().getOpposite())) {
                return be.itemHandler;
            }
            return null;
        });
    }

    @Override
    public IEMenuTypes.ArgContainer<TurretGunBlockEntity, ?> getContainerType() {
        return IEMenuTypes.GUN_TURRET;
    }
}

