/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class RedstoneStateCellBlockEntity
extends ConnectorRedstoneBlockEntity {
    public DyeColor redstoneChannelSet = DyeColor.WHITE;
    public DyeColor redstoneChannelReset = DyeColor.WHITE;
    boolean wasToggled = false;
    private static final Map<Direction, VoxelShape> SHAPES = (Map)Util.make(new EnumMap(Direction.class), map -> {
        float wMin = 0.3125f;
        float wMax = 0.6875f;
        map.put(Direction.NORTH, Shapes.box((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.875));
        map.put(Direction.SOUTH, Shapes.box((double)0.3125, (double)0.3125, (double)0.125, (double)0.6875, (double)0.6875, (double)1.0));
        map.put(Direction.WEST, Shapes.box((double)0.0, (double)0.3125, (double)0.3125, (double)0.875, (double)0.6875, (double)0.6875));
        map.put(Direction.EAST, Shapes.box((double)0.125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875));
        map.put(Direction.DOWN, Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.875, (double)0.6875));
        map.put(Direction.UP, Shapes.box((double)0.3125, (double)0.125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875));
    });

    public RedstoneStateCellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ConnectorRedstoneBlockEntity>)((BlockEntityType)IEBlockEntities.REDSTONE_STATE_CELL.get()), pos, state);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.output > 0 && this.level.getGameTime() % 32L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x1F)) {
                Direction dir = this.getFacing();
                Vec3 particlePos = Vec3.atCenterOf((Vec3i)this.getPosition()).add((double)dir.getStepX() * 0.25, (double)dir.getStepY() * 0.25, (double)dir.getStepZ() * 0.25);
                serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 0.5f), particlePos.x, particlePos.y, particlePos.z, 4, 0.05, 0.05, 0.05, 0.0);
            }
        }
    }

    @Override
    public boolean isRSInput() {
        return false;
    }

    @Override
    public boolean isRSOutput() {
        return false;
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.level.isClientSide && SafeChunkUtils.isChunkSafe((LevelAccessor)this.level, this.worldPosition)) {
            byte setVal = handler.getValue(this.redstoneChannelSet.getId());
            byte resetVal = handler.getValue(this.redstoneChannelReset.getId());
            int oldOutput = this.output;
            if (this.redstoneChannelReset == this.redstoneChannelSet) {
                if (setVal <= 0) {
                    this.wasToggled = false;
                } else if (!this.wasToggled) {
                    this.output = this.output > 0 ? (byte)0 : setVal;
                    this.wasToggled = true;
                }
            } else if (setVal > 0) {
                this.output = setVal;
            } else if (resetVal > 0) {
                this.output = 0;
            }
            if (!this.isRemoved() && this.output != oldOutput) {
                this.rsDirty = true;
            }
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        signals[this.redstoneChannel.ordinal()] = (byte)this.output;
        this.rsDirty = false;
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.level.isClientSide) {
            ImmersiveEngineering.proxy.openTileScreen("redstonestatecell", this);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("redstoneChannelSet")) {
            this.redstoneChannelSet = DyeColor.byId((int)message.getInt("redstoneChannelSet"));
        }
        if (message.contains("redstoneChannelReset")) {
            this.redstoneChannelReset = DyeColor.byId((int)message.getInt("redstoneChannelReset"));
        }
        if (message.contains("redstoneChannel")) {
            this.redstoneChannel = DyeColor.byId((int)message.getInt("redstoneChannel"));
        }
        this.updateAfterConfigure();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        nbt.putInt("redstoneChannelSet", this.redstoneChannelSet.getId());
        nbt.putInt("redstoneChannelReset", this.redstoneChannelReset.getId());
        nbt.putBoolean("wasToggled", this.wasToggled);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        this.redstoneChannelSet = DyeColor.byId((int)nbt.getInt("redstoneChannelSet"));
        this.redstoneChannelReset = DyeColor.byId((int)nbt.getInt("redstoneChannelReset"));
        this.wasToggled = nbt.getBoolean("wasToggled");
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double conRadius = type.getRenderDiameter() / 2.0;
        return new Vec3(0.5 + (double)side.getStepX() * (0.25 - conRadius), 0.5 + (double)side.getStepY() * (0.25 - conRadius), 0.5 + (double)side.getStepZ() * (0.25 - conRadius));
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.getFacing());
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return null;
        }
        return new Component[]{Component.empty().append((Component)Component.translatable((String)"gui.immersiveengineering.config.redstone_color_set")).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)("color.minecraft." + this.redstoneChannelSet.getName()))), Component.empty().append((Component)Component.translatable((String)"gui.immersiveengineering.config.redstone_color_reset")).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)("color.minecraft." + this.redstoneChannelReset.getName()))), Component.empty().append((Component)Component.translatable((String)"gui.immersiveengineering.config.redstone_color_output")).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)("color.minecraft." + this.redstoneChannel.getName())))};
    }
}

