/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import net.minecraft.client.resources.language.I18n;

public enum TimestampFormat {
    D,
    H,
    M,
    S,
    MS,
    HMS,
    HM,
    DHMS,
    DHM,
    DH;

    static TimestampFormat[] coreValues;

    public boolean containsFormat(TimestampFormat format) {
        return this.toString().contains(format.toString());
    }

    public long getTickCut() {
        return this == D ? 1728000L : (this == H ? 72000L : (this == M ? 1200L : (this == S ? 20L : 1L)));
    }

    public String getLocalKey() {
        return this == D ? "day" : (this == H ? "hour" : (this == M ? "minute" : (this == S ? "second" : "")));
    }

    public static String formatTimestamp(long timestamp, TimestampFormat format) {
        StringBuilder s = new StringBuilder();
        for (TimestampFormat core : coreValues) {
            if (!format.containsFormat(core) || timestamp < core.getTickCut()) continue;
            s.append(I18n.get((String)("desc.immersiveengineering.info." + core.getLocalKey()), (Object[])new Object[]{Long.toString(timestamp / core.getTickCut())}));
            timestamp %= core.getTickCut();
        }
        if (s.length() == 0) {
            for (int i = coreValues.length - 1; i >= 0; --i) {
                if (!format.containsFormat(coreValues[i])) continue;
                s = new StringBuilder(I18n.get((String)("desc.immersiveengineering.info." + coreValues[i].getLocalKey()), (Object[])new Object[]{0}));
                break;
            }
        }
        return s.toString();
    }

    static {
        coreValues = new TimestampFormat[]{D, H, M, S};
    }
}

