/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.mixin.accessors.CropBlockAccess;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.function.Function;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeMapCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class ClocheRenderFunctions {
    public static void init() {
        ClocheRecipe.registerSoilTexture(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIRT), new ItemStack((ItemLike)Items.COARSE_DIRT), new ItemStack((ItemLike)Items.GRASS_BLOCK), new ItemStack((ItemLike)Items.DIRT_PATH)}), ResourceLocation.withDefaultNamespace((String)"block/farmland_moist"));
        ClocheRenderFunctions.register("crop", RenderFunctionCrop.CODEC);
        ClocheRenderFunctions.register("stacking", RenderFunctionStacking.CODEC);
        ClocheRenderFunctions.register("stem", RenderFunctionStem.CODEC);
        ClocheRenderFunctions.register("generic", RenderFunctionGeneric.CODEC);
        ClocheRenderFunctions.register("doubleflower", RenderFunctionDoubleFlower.CODEC);
        ClocheRenderFunctions.register("hemp", RenderFunctionHemp.CODEC);
        ClocheRenderFunctions.register("chorus", RenderFunctionChorus.CODEC);
    }

    private static void register(String path, DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec) {
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put((Object)IEApi.ieLoc(path), codec);
    }

    private static <F extends ClocheRenderFunction> DualMapCodec<? super RegistryFriendlyByteBuf, F> byBlockCodec(Function<F, Block> getBlock, Function<Block, F> make) {
        return DualCodecs.registryEntry((Registry)BuiltInRegistries.BLOCK).map(make, getBlock).fieldOf("block");
    }

    public static class RenderFunctionCrop
    implements ClocheRenderFunction {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionCrop> CODEC = ClocheRenderFunctions.byBlockCodec(f -> f.cropBlock, RenderFunctionCrop::new);
        final Block cropBlock;
        int maxAge;
        IntegerProperty ageProperty;

        public RenderFunctionCrop(Block cropBlock) {
            this.cropBlock = cropBlock;
            if (cropBlock instanceof CropBlock) {
                this.maxAge = ((CropBlock)cropBlock).getMaxAge();
                this.ageProperty = ((CropBlockAccess)cropBlock).invokeGetAgeProperty();
            } else {
                for (Property prop : cropBlock.defaultBlockState().getProperties()) {
                    if (!"age".equals(prop.getName()) || !(prop instanceof IntegerProperty)) continue;
                    int tmp = -1;
                    for (Integer allowed : ((IntegerProperty)prop).getPossibleValues()) {
                        if (allowed == null || allowed <= tmp) continue;
                        tmp = allowed;
                    }
                    if (tmp <= 0) continue;
                    this.maxAge = tmp;
                    this.ageProperty = (IntegerProperty)prop;
                    break;
                }
            }
            if (this.ageProperty == null || this.maxAge <= 0) {
                throw new IllegalArgumentException("Block " + cropBlock.getDescriptionId() + " is not a valid crop block");
            }
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.875f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            BlockState state;
            int age = Math.min(this.maxAge, Math.round((float)this.maxAge * growth));
            Block block = this.cropBlock;
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                state = crop.getStateForAge(age);
            } else {
                state = (BlockState)this.cropBlock.defaultBlockState().setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(age));
            }
            return ImmutableList.of((Object)Pair.of((Object)state, (Object)new Transformation(null)));
        }

        @Override
        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }

    public static class RenderFunctionStacking
    implements ClocheRenderFunction {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionStacking> CODEC = ClocheRenderFunctions.byBlockCodec(f -> f.cropBlock, RenderFunctionStacking::new);
        final Block cropBlock;

        public RenderFunctionStacking(Block cropBlock) {
            this.cropBlock = cropBlock;
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.6875f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            Transformation bottom = new Transformation(new Vector3f(0.0f, growth - 1.0f, 0.0f), null, null, null);
            Transformation top = new Transformation(new Vector3f(0.0f, growth, 0.0f), null, null, null);
            return ImmutableList.of((Object)Pair.of((Object)this.cropBlock.defaultBlockState(), (Object)bottom), (Object)Pair.of((Object)this.cropBlock.defaultBlockState(), (Object)top));
        }

        @Override
        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }

    public record RenderFunctionStem(Block cropBlock, Block stemBlock, Block attachedStemBlock) implements ClocheRenderFunction
    {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionStem> CODEC = DualCompositeMapCodecs.composite((DualMapCodec)DualCodecs.registryEntry((Registry)BuiltInRegistries.BLOCK).fieldOf("crop"), f -> f.cropBlock, (DualMapCodec)DualCodecs.registryEntry((Registry)BuiltInRegistries.BLOCK).fieldOf("stem"), f -> f.stemBlock, (DualMapCodec)DualCodecs.registryEntry((Registry)BuiltInRegistries.BLOCK).fieldOf("attachedStem"), f -> f.attachedStemBlock, RenderFunctionStem::new);

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 1.0f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            PoseStack transform = new PoseStack();
            transform.translate(0.0f, 0.0625f, 0.25f);
            if ((double)growth < 0.375) {
                int age = Math.round(7.0f * growth / 0.375f);
                return ImmutableList.of((Object)Pair.of((Object)((BlockState)this.stemBlock.defaultBlockState().setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(age))), (Object)new Transformation(transform.last().pose())));
            }
            float scale = (growth - 0.375f) / 0.625f * 0.3125f;
            Transformation cropMatrix = new Transformation(new Vector3f(0.5f - scale / 2.0f, 0.5625f - scale, 0.25f - scale / 2.0f), null, new Vector3f(scale, scale, scale), null);
            return ImmutableList.of((Object)Pair.of((Object)this.attachedStemBlock.defaultBlockState(), (Object)new Transformation(transform.last().pose())), (Object)Pair.of((Object)this.cropBlock.defaultBlockState(), (Object)cropMatrix));
        }

        @Override
        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }

    public static class RenderFunctionGeneric
    implements ClocheRenderFunction {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionGeneric> CODEC = ClocheRenderFunctions.byBlockCodec(f -> f.cropBlock, RenderFunctionGeneric::new);
        final Block cropBlock;

        public RenderFunctionGeneric(Block cropBlock) {
            this.cropBlock = cropBlock;
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.75f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            Vector3f transl = new Vector3f(0.5f - growth / 2.0f, 0.0f, 0.5f - growth / 2.0f);
            Vector3f scale = new Vector3f(growth, growth, growth);
            return ImmutableList.of((Object)Pair.of((Object)this.cropBlock.defaultBlockState(), (Object)new Transformation(transl, null, scale, null)));
        }

        @Override
        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }

    public static class RenderFunctionDoubleFlower
    implements ClocheRenderFunction {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionDoubleFlower> CODEC = ClocheRenderFunctions.byBlockCodec(f -> f.cropBlock, RenderFunctionDoubleFlower::new);
        final Block cropBlock;

        public RenderFunctionDoubleFlower(Block cropBlock) {
            this.cropBlock = cropBlock;
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.75f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            Vector3f transl = new Vector3f(0.5f - growth / 2.0f, 0.0f, 0.5f - growth / 2.0f);
            Vector3f transl1 = new Vector3f(0.5f - growth / 2.0f, 0.0f + growth, 0.5f - growth / 2.0f);
            Vector3f scale = new Vector3f(growth, growth, growth);
            return ImmutableList.of((Object)Pair.of((Object)this.cropBlock.defaultBlockState(), (Object)new Transformation(transl, null, scale, null)), (Object)Pair.of((Object)((BlockState)this.cropBlock.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)), (Object)new Transformation(transl1, null, scale, null)));
        }

        @Override
        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }

    public static class RenderFunctionHemp
    implements ClocheRenderFunction {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionHemp> CODEC = DualMapCodec.unit((Object)new RenderFunctionHemp());

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.6875f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            int age = Math.min(4, Math.round(growth * 4.0f));
            if (age == 4) {
                Transformation top = new Transformation(new Vector3f(0.0f, 1.0f, 0.0f), null, null, null);
                return ImmutableList.of((Object)Pair.of((Object)((BlockState)IEBlocks.Misc.HEMP_PLANT.defaultBlockState().setValue((Property)HempBlock.AGE, (Comparable)Integer.valueOf(4))), (Object)new Transformation(null)), (Object)Pair.of((Object)((BlockState)IEBlocks.Misc.HEMP_PLANT.defaultBlockState().setValue((Property)HempBlock.TOP, (Comparable)Boolean.valueOf(true))), (Object)top));
            }
            return ImmutableList.of((Object)Pair.of((Object)((BlockState)IEBlocks.Misc.HEMP_PLANT.defaultBlockState().setValue((Property)HempBlock.AGE, (Comparable)Integer.valueOf(age))), (Object)new Transformation(null)));
        }

        @Override
        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }

    public static class RenderFunctionChorus
    implements ClocheRenderFunction {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionChorus> CODEC = DualMapCodec.unit((Object)new RenderFunctionChorus());

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.5f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            Transformation bottom = new Transformation(new Vector3f(0.0f, (growth *= 2.0f) - 2.0f, 0.0f), null, null, null);
            Transformation middle = new Transformation(new Vector3f(0.0f, growth - 1.0f, 0.0f), null, null, null);
            Transformation top = new Transformation(new Vector3f(0.0f, growth, 0.0f), null, null, null);
            BlockState stem = (BlockState)((BlockState)Blocks.CHORUS_PLANT.defaultBlockState().setValue((Property)ChorusPlantBlock.DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)ChorusPlantBlock.UP, (Comparable)Boolean.valueOf(true));
            return ImmutableList.of((Object)Pair.of((Object)stem, (Object)bottom), (Object)Pair.of((Object)stem, (Object)middle), (Object)Pair.of((Object)Blocks.CHORUS_FLOWER.defaultBlockState(), (Object)top));
        }

        @Override
        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }
}

