/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class GuiButtonState<E>
extends Button
implements ITooltipWidget {
    public E[] states;
    private final IntSupplier state;
    private final BiConsumer<List<Component>, E> tooltip;
    private final Map<E, GuiButtonIE.ButtonTexture> texture;
    public int[] textOffset;

    protected static <E> Map<E, GuiButtonIE.ButtonTexture> allSame(E[] keys, GuiButtonIE.ButtonTexture texture) {
        HashMap<E, GuiButtonIE.ButtonTexture> map = new HashMap<E, GuiButtonIE.ButtonTexture>();
        for (E key : keys) {
            map.put(key, texture);
        }
        return map;
    }

    public GuiButtonState(int x, int y, int w, int h, Component name, E[] states, IntSupplier state, Map<E, GuiButtonIE.ButtonTexture> texture, GuiButtonIE.IIEPressable<GuiButtonState<E>> handler) {
        this(x, y, w, h, name, states, state, texture, handler, (a, b) -> {});
    }

    public GuiButtonState(int x, int y, int w, int h, Component name, E[] states, IntSupplier state, Map<E, GuiButtonIE.ButtonTexture> texture, GuiButtonIE.IIEPressable<GuiButtonState<E>> handler, BiConsumer<List<Component>, E> tooltip) {
        super(x, y, w, h, name, handler, DEFAULT_NARRATION);
        this.states = states;
        this.state = state;
        this.tooltip = tooltip;
        this.textOffset = new int[]{this.width + 1, this.height / 2 - 3};
        this.texture = texture;
    }

    protected int getNextStateInt() {
        return (this.state.getAsInt() + 1) % this.states.length;
    }

    public E getNextState() {
        return this.states[this.getNextStateInt()];
    }

    public E getState() {
        return this.states[this.state.getAsInt()];
    }

    protected int getStateAsInt() {
        return this.state.getAsInt();
    }

    public int[] getTextOffset(Font fontrenderer) {
        return this.textOffset;
    }

    protected int getTextColor(boolean highlighted) {
        if (!this.active) {
            return 0xA0A0A0;
        }
        if (highlighted) {
            return -557004;
        }
        return 0xE0E0E0;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Font fontrenderer = mc.font;
        this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        graphics.blitSprite(this.texture.get(this.states[this.state.getAsInt()]).get(this.isHovered), this.getX(), this.getY(), this.width, this.height);
        if (!this.getMessage().getString().isEmpty()) {
            int[] offset = this.getTextOffset(fontrenderer);
            graphics.drawString(fontrenderer, this.getMessage(), this.getX() + offset[0], this.getY() + offset[1], this.getTextColor(this.isHovered), false);
        }
    }

    @Override
    public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
        this.tooltip.accept(tooltip, this.getState());
    }
}

