/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.SorterScreen;
import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.FluidSorterMenu;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class FluidSorterScreen
extends IEContainerScreen<FluidSorterMenu> {
    private final List<SorterScreen.ButtonSorter> sorterButtons = new ArrayList<SorterScreen.ButtonSorter>(6);

    public FluidSorterScreen(FluidSorterMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, FluidSorterScreen.makeTextureLocation("sorter"));
        this.imageHeight = 244;
        this.inventoryLabelY = this.imageHeight - 91;
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                if (((FluidSorterMenu)this.menu).getFilter(side, i).isEmpty() || !this.getSlotArea(side, i).contains(mouseX, mouseY)) continue;
                FluidInfoArea.fillTooltip(((FluidSorterMenu)this.menu).getFilter(side, i), -1, addLine);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        RegistryAccess registries = Minecraft.getInstance().level.registryAccess();
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                if (!this.getSlotArea(side, i).contains((int)mouseX, (int)mouseY)) continue;
                ItemStack stack = ((FluidSorterMenu)this.menu).getCarried();
                if (stack.isEmpty()) {
                    this.setFluidInSlot(side, i, FluidStack.EMPTY, (HolderLookup.Provider)registries);
                } else {
                    int finalSide = side;
                    int finalI = i;
                    FluidUtil.getFluidContained((ItemStack)stack).ifPresent(fs -> this.setFluidInSlot(finalSide, finalI, (FluidStack)fs, (HolderLookup.Provider)registries));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        int side;
        MultiBufferSource.BufferSource buffers = graphics.bufferSource();
        VertexConsumer builder = buffers.getBuffer(IERenderTypes.getGui(InventoryMenu.BLOCK_ATLAS));
        for (side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                FluidStack filter = ((FluidSorterMenu)this.menu).getFilter(side, i);
                if (filter.isEmpty()) continue;
                IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)filter.getFluid());
                TextureAtlasSprite sprite = ClientUtils.getSprite(props.getStillTexture(filter));
                Rect2i slotArea = this.getSlotArea(side, i);
                int col = props.getTintColor(filter);
                graphics.blit(slotArea.getX(), slotArea.getY(), 0, slotArea.getWidth(), slotArea.getHeight(), sprite, (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f);
            }
        }
        for (side = 0; side < 6; ++side) {
            int x = this.leftPos + 30 + side / 2 * 58;
            int y = this.topPos + 44 + side % 2 * 76;
            String s = I18n.get((String)("desc.immersiveengineering.info.blockSide." + String.valueOf(Direction.from3DDataValue((int)side))), (Object[])new Object[0]).substring(0, 1);
            graphics.drawString(ClientUtils.font(), s, x - ClientUtils.font().width(s) / 2, y, -1429418804, true);
        }
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.sorterButtons.clear();
        int side = 0;
        while (side < 6) {
            int x = this.leftPos + 21 + side / 2 * 58;
            int y = this.topPos + 3 + side % 2 * 76;
            int sideFinal = side++;
            BooleanSupplier value = () -> ((FluidSorterMenu)this.menu).sortWithNBT.get()[sideFinal] != 0;
            SorterScreen.ButtonSorter b = new SorterScreen.ButtonSorter(x, y, SorterScreen.FilterBit.NBT, () -> new SorterBlockEntity.FilterConfig(false, value.getAsBoolean(), false), btn -> {
                CompoundTag tag = new CompoundTag();
                tag.putInt("useNBT", value.getAsBoolean() ? 0 : 1);
                tag.putInt("side", sideFinal);
                this.sendUpdateToServer(tag);
                this.fullInit();
            });
            this.sorterButtons.add(b);
            this.addRenderableWidget((GuiEventListener)b);
        }
    }

    public void setFluidInSlot(int side, int slot, FluidStack fluid, HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("filter_side", side);
        tag.putInt("filter_slot", slot);
        if (fluid != null) {
            tag.put("filter", fluid.save(provider));
        }
        this.sendUpdateToServer(tag);
    }

    protected Rect2i getSlotArea(int side, int i) {
        int x = this.leftPos + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
        int y = this.topPos + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
        return new Rect2i(x, y, 16, 16);
    }
}

