/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonItem;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.gui.AutoWorkbenchMenu;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class AutoWorkbenchScreen
extends IEContainerScreen<AutoWorkbenchMenu> {
    private final List<GuiButtonItem> selectionButtons = new ArrayList<GuiButtonItem>();

    public AutoWorkbenchScreen(AutoWorkbenchMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, AutoWorkbenchScreen.makeTextureLocation("auto_workbench"));
        this.imageHeight = 184;
        this.inventoryLabelY = 93;
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 80, this.topPos + 36, (IEnergyStorage)((AutoWorkbenchMenu)this.menu).energyStorage));
    }

    @Override
    public void init() {
        List<RecipeHolder<BlueprintCraftingRecipe>> recipes;
        this.clearWidgets();
        this.selectionButtons.clear();
        super.init();
        Slot s = ((AutoWorkbenchMenu)this.menu).getSlot(0);
        if (s != null && s.hasItem() && s.getItem().getItem() instanceof EngineersBlueprintItem && (recipes = BlueprintCraftingRecipe.findRecipes((Level)Minecraft.getInstance().level, (String)s.getItem().get(IEApiDataComponents.BLUEPRINT_TYPE))) != null && !recipes.isEmpty()) {
            int l = recipes.size();
            int xx = this.leftPos + 121;
            int yy = this.topPos + (l > 6 ? 59 - (l - 3) / 3 * 18 : (l > 3 ? 59 : 68));
            for (int i = 0; i < l; ++i) {
                if (((BlueprintCraftingRecipe)recipes.get((int)i).value()).output.get().isEmpty()) continue;
                GuiButtonItem button = this.makeSelectionButton(xx, yy, i, ((BlueprintCraftingRecipe)recipes.get((int)i).value()).output.get().copy());
                this.selectionButtons.add(button);
                this.addRenderableWidget((GuiEventListener)button);
            }
        }
    }

    private GuiButtonItem makeSelectionButton(int xx, int yy, int i, ItemStack stack) {
        Button.OnPress handler = btn -> {
            int newId = i == ((AutoWorkbenchMenu)this.menu).selectedRecipe.get() ? -1 : i;
            CompoundTag message = new CompoundTag();
            message.putInt("recipe", newId);
            this.sendUpdateToServer(message);
        };
        return new GuiButtonItem(xx + i % 3 * 18, yy + i / 3 * 18, stack, false, handler);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        for (int i = 0; i < this.selectionButtons.size(); ++i) {
            this.selectionButtons.get((int)i).state = i == ((AutoWorkbenchMenu)this.menu).selectedRecipe.get();
        }
        super.drawContainerBackgroundPre(graphics, partialTicks, x, y);
    }
}

