/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.mixin.accessors.client.ParticleManagerAccess;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;

public class CustomParticleManager {
    private final List<Particle> particles = new ArrayList<Particle>();

    public void clientTick() {
        Iterator<Particle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            Particle p = iterator.next();
            p.tick();
            if (p.isAlive()) continue;
            iterator.remove();
        }
    }

    public <T extends ParticleOptions> void add(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int maxAge) {
        Particle newParticle = ((ParticleManagerAccess)Minecraft.getInstance().particleEngine).invokeMakeParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (newParticle == null) {
            return;
        }
        if (maxAge > 0) {
            newParticle.setLifetime(maxAge);
        }
        this.particles.add(newParticle);
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, float partialTicks) {
        if (this.particles.isEmpty()) {
            return;
        }
        matrixStack.pushPose();
        Camera activeInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        matrixStack.translate(activeInfo.getPosition().x, activeInfo.getPosition().y, activeInfo.getPosition().z);
        TransformingVertexBuilder particleBuilder = new TransformingVertexBuilder(IERenderTypes.whiteLightmap(bufferIn), IERenderTypes.PARTICLES, matrixStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        particleBuilder.setDefaultNormal(0.0f, 1.0f, 0.0f);
        particleBuilder.setDefaultOverlay(OverlayTexture.NO_OVERLAY);
        for (Particle p : this.particles) {
            p.render((VertexConsumer)particleBuilder, activeInfo, partialTicks);
        }
        matrixStack.popPose();
    }
}

