/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Unit;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BulletHandler {
    public static final SetRestrictedField<Function<IBullet<?>, Item>> GET_BULLET_ITEM = SetRestrictedField.common();
    public static ItemLike emptyCasing = Items.AIR;
    public static ItemLike emptyShell = Items.AIR;
    private static final BiMap<ResourceLocation, IBullet<?>> REGISTRY = HashBiMap.create();

    public static void registerBullet(ResourceLocation name, IBullet<?> bullet) {
        Preconditions.checkState((!REGISTRY.containsKey((Object)name) ? 1 : 0) != 0, (Object)(String.valueOf(name) + " is already registered"));
        Preconditions.checkState((!REGISTRY.containsValue(bullet) ? 1 : 0) != 0);
        REGISTRY.put((Object)name, bullet);
    }

    public static IBullet<?> getBullet(ResourceLocation name) {
        return (IBullet)REGISTRY.get((Object)name);
    }

    public static ResourceLocation findRegistryName(IBullet<?> bullet) {
        if (bullet != null) {
            return (ResourceLocation)REGISTRY.inverse().get(bullet);
        }
        return null;
    }

    public static ItemStack getBulletStack(ResourceLocation key) {
        return new ItemStack((ItemLike)BulletHandler.getBulletItem(key));
    }

    public static Item getBulletItem(ResourceLocation key) {
        return GET_BULLET_ITEM.get().apply(BulletHandler.getBullet(key));
    }

    public static Collection<ResourceLocation> getAllKeys() {
        return REGISTRY.keySet();
    }

    public static interface IBullet<StackData> {
        public CodecsAndDefault<StackData> getCodec();

        default public boolean isProperCartridge() {
            return true;
        }

        default public String getTranslationKey(StackData data, String baseName) {
            return baseName;
        }

        default public void addTooltip(StackData data, @Nullable Item.TooltipContext world, List<Component> list, TooltipFlag flag) {
        }

        default public int getProjectileCount(@Nullable Player shooter) {
            return 1;
        }

        default public Entity getProjectile(@Nullable Player shooter, StackData data, Entity projectile, boolean charged) {
            return projectile;
        }

        public void onHitTarget(Level var1, HitResult var2, @Nullable UUID var3, Entity var4, boolean var5, StackData var6);

        public ItemStack getCasing(ItemStack var1);

        public ResourceLocation[] getTextures();

        default public Color4 getColour(StackData data, int layer) {
            return Color4.WHITE;
        }

        default public boolean isValidForTurret() {
            return false;
        }

        default public SoundEvent getSound() {
            return null;
        }
    }

    public record CodecsAndDefault<T>(DualCodec<? super RegistryFriendlyByteBuf, T> codecs, T defaultValue) {
        public static final CodecsAndDefault<Unit> UNIT = new CodecsAndDefault<Unit>(DualCodecs.unit((Object)Unit.INSTANCE), Unit.INSTANCE);
    }

    public static class DamagingBullet<StackData>
    implements IBullet<StackData> {
        private final CodecsAndDefault<StackData> codec;
        private final DamageSourceProvider damageSourceGetter;
        private final DoubleSupplier damage;
        private final boolean resetHurt;
        private final boolean setFire;
        private final Supplier<ItemStack> casing;
        private final ResourceLocation[] textures;

        public DamagingBullet(CodecsAndDefault<StackData> codec, DamageSourceProvider damageSourceGetter, float damage, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this(codec, damageSourceGetter, damage, false, false, casing, textures);
        }

        public DamagingBullet(CodecsAndDefault<StackData> codec, DamageSourceProvider damageSourceGetter, DoubleSupplier damage, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this(codec, damageSourceGetter, damage, false, false, casing, textures);
        }

        public DamagingBullet(CodecsAndDefault<StackData> codec, DamageSourceProvider damageSourceGetter, float damage, boolean resetHurt, boolean setFire, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this(codec, damageSourceGetter, () -> damage, resetHurt, setFire, casing, textures);
        }

        public DamagingBullet(CodecsAndDefault<StackData> codec, DamageSourceProvider damageSourceGetter, DoubleSupplier damage, boolean resetHurt, boolean setFire, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this.codec = codec;
            this.damageSourceGetter = damageSourceGetter;
            this.damage = damage;
            this.resetHurt = resetHurt;
            this.setFire = setFire;
            this.casing = casing;
            this.textures = textures;
        }

        protected float getDamage(Entity hitEntity, boolean headshot) {
            return (float)(this.damage.getAsDouble() * (double)(headshot ? 1.5f : 1.0f));
        }

        @Override
        public void onHitTarget(Level world, HitResult rtr, @Nullable UUID shooterUUID, Entity projectile, boolean headshot, StackData bulletData) {
            if (!(rtr instanceof EntityHitResult)) {
                return;
            }
            EntityHitResult target = (EntityHitResult)rtr;
            Entity hitEntity = target.getEntity();
            if (!world.isClientSide && hitEntity != null && this.damageSourceGetter != null) {
                Entity shooter = null;
                if (shooterUUID != null && world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    shooter = serverLevel.getEntity(shooterUUID);
                }
                if (hitEntity.hurt(this.damageSourceGetter.getSource(projectile, shooter, hitEntity), this.getDamage(hitEntity, headshot))) {
                    if (this.resetHurt) {
                        hitEntity.invulnerableTime = 0;
                    }
                    if (this.setFire) {
                        hitEntity.igniteForSeconds(3.0f);
                    }
                }
            }
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return (ItemStack)this.casing.get();
        }

        @Override
        public ResourceLocation[] getTextures() {
            return this.textures;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }

        @Override
        public CodecsAndDefault<StackData> getCodec() {
            return this.codec;
        }

        public static interface DamageSourceProvider {
            public DamageSource getSource(Entity var1, Entity var2, Entity var3);
        }
    }
}

