/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.serialization.MapReader;
import tv.soaryn.xycraft.core.utils.serialization.MapWriter;

public class NbtEncoding
implements MapWriter.NodeEmitter<Tag> {
    public static final NbtEncoding INSTANCE = new NbtEncoding();

    public static <T> Tag encode(T value, MapWriter<T> serializer) {
        return serializer.serialize(value, INSTANCE);
    }

    public static <T> T decode(Tag tag, @Nullable T prevValue, MapReader<T> deserializer) {
        return deserializer.deserialize(prevValue, new NodeToken(tag));
    }

    @Override
    public Tag makeEmpty() {
        return null;
    }

    @Override
    public Tag makeBoolean(boolean value) {
        return ByteTag.valueOf((boolean)value);
    }

    @Override
    public Tag makeByte(byte value) {
        return ByteTag.valueOf((byte)value);
    }

    @Override
    public Tag makeShort(short value) {
        return ShortTag.valueOf((short)value);
    }

    @Override
    public Tag makeInt(int value) {
        return IntTag.valueOf((int)value);
    }

    @Override
    public Tag makeLong(long value) {
        return LongTag.valueOf((long)value);
    }

    @Override
    public Tag makeFloat(float value) {
        return FloatTag.valueOf((float)value);
    }

    @Override
    public Tag makeDouble(double value) {
        return DoubleTag.valueOf((double)value);
    }

    @Override
    public Tag makeString(String value) {
        return StringTag.valueOf((String)value);
    }

    @Override
    public Tag makeBlob(Buffer value) {
        if (value instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)value;
            return new ByteArrayTag(Arrays.copyOf(buf.array(), buf.position()));
        }
        if (value instanceof IntBuffer) {
            IntBuffer buf = (IntBuffer)value;
            return new IntArrayTag(Arrays.copyOf(buf.array(), buf.position()));
        }
        if (value instanceof LongBuffer) {
            LongBuffer buf = (LongBuffer)value;
            return new LongArrayTag(Arrays.copyOf(buf.array(), buf.position()));
        }
        throw new IllegalArgumentException("Unsupported buffer type: " + String.valueOf(value.getClass()));
    }

    @Override
    public Tag makeList(Stream<Tag> values) {
        ListTag list = new ListTag();
        values.forEach(arg_0 -> list.add(arg_0));
        return list;
    }

    public ListBuilder buildList() {
        return new ListBuilder();
    }

    public MapBuilder buildMap() {
        return new MapBuilder();
    }

    private record NodeToken(Tag tag) implements MapReader.NodeToken<Tag>
    {
        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean asBoolean() {
            Tag tag = this.tag;
            if (tag instanceof NumericTag) {
                NumericTag t = (NumericTag)tag;
                return t.getAsByte() != 0;
            }
            throw new IllegalStateException("Not a boolean.");
        }

        @Override
        public byte asByte() {
            Tag tag = this.tag;
            if (tag instanceof NumericTag) {
                NumericTag t = (NumericTag)tag;
                return t.getAsByte();
            }
            throw new IllegalStateException("Not a byte.");
        }

        @Override
        public short asShort() {
            Tag tag = this.tag;
            if (tag instanceof NumericTag) {
                NumericTag t = (NumericTag)tag;
                return t.getAsShort();
            }
            throw new IllegalStateException("Not a short.");
        }

        @Override
        public int asInt() {
            Tag tag = this.tag;
            if (tag instanceof NumericTag) {
                NumericTag t = (NumericTag)tag;
                return t.getAsInt();
            }
            throw new IllegalStateException("Not an int.");
        }

        @Override
        public long asLong() {
            Tag tag = this.tag;
            if (tag instanceof NumericTag) {
                NumericTag t = (NumericTag)tag;
                return t.getAsLong();
            }
            throw new IllegalStateException("Not a long.");
        }

        @Override
        public float asFloat() {
            Tag tag = this.tag;
            if (tag instanceof NumericTag) {
                NumericTag t = (NumericTag)tag;
                return t.getAsFloat();
            }
            throw new IllegalStateException("Not a float.");
        }

        @Override
        public double asDouble() {
            Tag tag = this.tag;
            if (tag instanceof NumericTag) {
                NumericTag t = (NumericTag)tag;
                return t.getAsDouble();
            }
            throw new IllegalStateException("Not a double.");
        }

        @Override
        public String asString() {
            Tag tag = this.tag;
            if (tag instanceof StringTag) {
                StringTag t = (StringTag)tag;
                return t.getAsString();
            }
            throw new IllegalStateException("Not a byte.");
        }

        @Override
        public ByteBuffer asByteBlob() {
            Tag tag = this.tag;
            if (tag instanceof ByteArrayTag) {
                ByteArrayTag t = (ByteArrayTag)tag;
                return ByteBuffer.wrap(t.getAsByteArray());
            }
            throw new IllegalStateException("Not a byte blob.");
        }

        @Override
        public IntBuffer asIntBlob() {
            Tag tag = this.tag;
            if (tag instanceof IntArrayTag) {
                IntArrayTag t = (IntArrayTag)tag;
                return IntBuffer.wrap(t.getAsIntArray());
            }
            throw new IllegalStateException("Not an int blob.");
        }

        @Override
        public LongBuffer asLongBlob() {
            Tag tag = this.tag;
            if (tag instanceof LongArrayTag) {
                LongArrayTag t = (LongArrayTag)tag;
                return LongBuffer.wrap(t.getAsLongArray());
            }
            throw new IllegalStateException("Not a long blob.");
        }

        @Override
        public Stream<Tag> asList() {
            Tag tag = this.tag;
            if (tag instanceof ListTag) {
                ListTag t = (ListTag)tag;
                return t.stream();
            }
            throw new IllegalStateException("Not a list.");
        }

        public MapToken asMap() {
            Tag tag = this.tag;
            if (tag instanceof CompoundTag) {
                CompoundTag t = (CompoundTag)tag;
                return new MapToken(t);
            }
            throw new IllegalStateException("Not a byte blob.");
        }

        private record MapToken(CompoundTag tag) implements MapReader.NodeToken.MapToken<Tag>
        {
            @Override
            public boolean has(String key) {
                return this.tag.contains(key);
            }

            @Override
            public MapReader.NodeToken<Tag> get(String key) {
                Tag t = this.tag.get(key);
                return t == null ? EmptyToken.INSTANCE : new NodeToken(t);
            }
        }
    }

    public static class ListBuilder
    implements MapWriter.NodeEmitter.ListBuilder<Tag> {
        private final ListTag list = new ListTag();

        public ListBuilder add(Tag value) {
            this.list.add((Object)value);
            return this;
        }

        public ListBuilder addAll(Iterable<Tag> values) {
            values.forEach(arg_0 -> this.list.add(arg_0));
            return this;
        }

        @Override
        public Tag make() {
            return this.list;
        }
    }

    public static class MapBuilder
    implements MapWriter.NodeEmitter.MapBuilder<Tag> {
        private final CompoundTag tag = new CompoundTag();

        public MapBuilder put(String key, Tag value) {
            if (value != null) {
                this.tag.put(key, value);
            }
            return this;
        }

        @Override
        public Tag make() {
            return this.tag;
        }
    }

    private static class EmptyToken
    implements MapReader.NodeToken<Tag> {
        private static final EmptyToken INSTANCE = new EmptyToken();

        private EmptyToken() {
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean asBoolean() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public byte asByte() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public short asShort() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public int asInt() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public long asLong() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public float asFloat() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public double asDouble() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public String asString() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public ByteBuffer asByteBlob() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public IntBuffer asIntBlob() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public LongBuffer asLongBlob() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public Stream<Tag> asList() {
            throw new IllegalStateException("Empty.");
        }

        @Override
        public MapReader.NodeToken.MapToken<Tag> asMap() {
            throw new IllegalStateException("Empty.");
        }
    }
}

