/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.protocontainer;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;
import tv.soaryn.xycraft.core.utils.protocontainer.ResourceStack;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public final class ItemResource
implements IResource,
DataComponentHolder {
    public static final Codec<ItemResource> CODEC = ItemStack.SINGLE_ITEM_CODEC.xmap(ItemResource::of, ItemResource::toStack);
    public static final Codec<ItemResource> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(o -> o.orElse(EMPTY), r -> r.isEmpty() ? Optional.of(EMPTY) : Optional.of(r));
    public static final Codec<ResourceStack<ItemResource>> OPTIONAL_WITH_AMOUNT_CODEC = CodecUtils.Codecs.ITEM_STACK_OPTIONAL.xmap(stack -> new ResourceStack<ItemResource>(ItemResource.of(stack), stack.getCount()), stack -> ((ItemResource)stack.resource()).toStack(stack.amount()));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemResource> OPTIONAL_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), ItemResource::getItemHolder, (StreamCodec)DataComponentPatch.STREAM_CODEC, ItemResource::getComponentsPatch, ItemResource::of);
    public static final ItemResource EMPTY = new ItemResource(ItemStack.EMPTY);
    public static final ResourceStack<ItemResource> EMPTY_STACK = new ResourceStack<ItemResource>(EMPTY, 0);
    private final ItemStack innerStack;

    public static ItemResource of(ItemStack itemStack) {
        return itemStack.isEmpty() ? EMPTY : new ItemResource(itemStack.copyWithCount(1));
    }

    public static ItemResource of(ItemLike item) {
        return item == Items.AIR ? EMPTY : new ItemResource(new ItemStack(item));
    }

    public static ItemResource of(Holder<Item> item, DataComponentPatch patch) {
        return item.value() == Items.AIR ? EMPTY : new ItemResource(new ItemStack(item, 1, patch));
    }

    private ItemResource(ItemStack innerStack) {
        this.innerStack = innerStack;
    }

    @Override
    public boolean isEmpty() {
        return this.innerStack.isEmpty();
    }

    public boolean is(Item item) {
        return this.innerStack.is(item);
    }

    public ItemResource applyPatch(DataComponentPatch patch) {
        ItemStack stack = this.innerStack.copy();
        stack.applyComponents(patch);
        return new ItemResource(stack);
    }

    public <D> ItemResource set(DataComponentType<D> type, D data) {
        ItemStack stack = this.innerStack.copy();
        stack.set(type, data);
        return new ItemResource(stack);
    }

    public <D> ItemResource set(Supplier<DataComponentType<D>> type, D data) {
        return this.set(type.get(), data);
    }

    public ItemResource remove(DataComponentType<?> type) {
        ItemStack stack = this.innerStack.copy();
        stack.remove(type);
        return new ItemResource(stack);
    }

    public ItemResource remove(Supplier<? extends DataComponentType<?>> type) {
        return this.remove(type.get());
    }

    public Item getItem() {
        return this.innerStack.getItem();
    }

    public Holder<Item> getItemHolder() {
        return this.innerStack.getItemHolder();
    }

    public DataComponentMap getComponents() {
        return this.innerStack.getComponents();
    }

    public DataComponentPatch getComponentsPatch() {
        return this.innerStack.getComponentsPatch();
    }

    public boolean matches(ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.innerStack);
    }

    public ItemStack toStack() {
        return this.toStack(1);
    }

    public ItemStack toStack(int count) {
        return count == 0 || this.isEmpty() ? ItemStack.EMPTY : this.innerStack.copyWithCount(count);
    }

    public List<ItemStack> toStacks(int count) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int stackCount = count / this.getMaxStackSize();
        for (int i = 0; i < stackCount; ++i) {
            stacks.add(this.toStack(this.getMaxStackSize()));
        }
        int remainder = count % this.getMaxStackSize();
        if (remainder > 0) {
            stacks.add(this.toStack(remainder));
        }
        return stacks;
    }

    public int getMaxStackSize() {
        return this.innerStack.getMaxStackSize();
    }

    public boolean canEquip(EquipmentSlot slot, LivingEntity entity) {
        return this.innerStack.canEquip(slot, entity);
    }

    public boolean canUnequip() {
        return !EnchantmentHelper.has((ItemStack)this.innerStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemResource)) return false;
        ItemResource v = (ItemResource)obj;
        if (!ItemStack.isSameItemSameComponents((ItemStack)v.innerStack, (ItemStack)this.innerStack)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.hashItemAndComponents((ItemStack)this.innerStack);
    }
}

