/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.systems;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.registries.CoreSystems;
import tv.soaryn.xycraft.core.content.systems.ISystemData;

public abstract class LevelSystemBase<T extends ISystemData> {
    private final Lazy<ResourceLocation> resourceLoc = Lazy.of(() -> CoreSystems.MapRegistry.getKey((Object)this));

    protected LevelSystemBase() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, event -> this.tick((LevelTickEvent)event, "xycraft:system.pre", this::preTick));
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, event -> this.tick((LevelTickEvent)event, "xycraft:system.post", this::postTick));
    }

    public String getName() {
        return ((ResourceLocation)this.resourceLoc.get()).getPath();
    }

    public boolean overridesEnabledFlag() {
        return false;
    }

    public T getData(Level level) {
        return (T)((ISystemData)level.getData(this.getAttachmentType()));
    }

    private void tick(LevelTickEvent event, String header, BiConsumer<LevelTickEvent, T> consumer) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        T data = this.getData(level);
        if (!this.overridesEnabledFlag() && !data.enabled()) {
            return;
        }
        ProfilerFiller profiler = level.getProfiler();
        profiler.push(header);
        profiler.push(level.dimension().location().toLanguageKey());
        consumer.accept(event, (LevelTickEvent)data);
        profiler.pop();
        profiler.pop();
    }

    @NotNull
    protected abstract Supplier<AttachmentType<T>> getAttachmentType();

    public void preTick(LevelTickEvent event, T data) {
    }

    public void postTick(LevelTickEvent event, T data) {
    }
}

