/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfml.ast.Block;
import ca.teamdman.sfml.ast.Interval;
import ca.teamdman.sfml.ast.ShortStatement;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.Trigger;
import java.util.List;

public record TimerTrigger(Interval interval, Block block) implements Trigger,
ShortStatement
{
    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public boolean shouldTick(ProgramContext context) {
        if (context.getBehaviour() instanceof SimulateExploreAllPathsProgramBehaviour) {
            return true;
        }
        return context.getManager().getTick() % this.interval.getTicks() == 0;
    }

    @Override
    public void tick(ProgramContext context) {
        this.block.tick(context);
        ProgramBehaviour programBehaviour = context.getBehaviour();
        if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
            SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
            simulation.onTriggerDropped(context, this);
        }
    }

    @Override
    public List<Statement> getStatements() {
        return List.of(this.block);
    }

    public boolean usesOnlyForgeEnergyResourceIO() {
        return this.getReferencedIOResourceIds().allMatch(id -> id.resourceTypeNamespace.equals("sfm") && (id.resourceTypeName.equals("forge_energy") || id.resourceTypeName.equals("mekanism_energy")));
    }

    @Override
    public String toString() {
        return "EVERY " + String.valueOf(this.interval) + " DO\n" + this.block.toString().indent(1).stripTrailing() + "\nEND";
    }

    @Override
    public String toStringShort() {
        return "EVERY " + String.valueOf(this.interval) + " DO";
    }
}

