/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.With;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;

public record ResourceLimit<STACK, ITEM, CAP>(ResourceIdentifier<STACK, ITEM, CAP> resourceId, Limit limit, With<STACK> with) implements ASTNode,
Predicate<Object>
{
    public static final ResourceLimit<?, ?, ?> TAKE_ALL_LEAVE_NONE = new ResourceLimit(ResourceIdentifier.MATCH_ALL, Limit.MAX_QUANTITY_NO_RETENTION, With.ALWAYS_TRUE);
    public static final ResourceLimit<?, ?, ?> ACCEPT_ALL_WITHOUT_RESTRAINT = new ResourceLimit(ResourceIdentifier.MATCH_ALL, Limit.MAX_QUANTITY_MAX_RETENTION, With.ALWAYS_TRUE);

    public ResourceLimit<STACK, ITEM, CAP> withDefaultLimit(Limit defaults) {
        return new ResourceLimit<STACK, ITEM, CAP>(this.resourceId, this.limit.withDefaults(defaults), this.with);
    }

    public ResourceLimit<STACK, ITEM, CAP> withLimit(Limit limit) {
        return new ResourceLimit<STACK, ITEM, CAP>(this.resourceId, limit, this.with);
    }

    public void gatherInputTrackers(Consumer<InputResourceTracker<?, ?, ?>> gatherer, ResourceIdSet exclusions) {
        if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                gatherer.accept(new InputResourceTracker(this, exclusions, new AtomicLong(0L), new AtomicLong(0L)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                AtomicLong quantity = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new InputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit, this.with), exclusions, quantity, new AtomicLong(0L))));
            }
        } else if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                AtomicLong retention = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new InputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit, this.with), exclusions, new AtomicLong(0L), retention)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                this.resourceId.expand().forEach(rid -> gatherer.accept(new InputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit, this.with), exclusions, new AtomicLong(0L), new AtomicLong(0L))));
            }
        }
    }

    public void gatherOutputTrackers(Consumer<OutputResourceTracker<?, ?, ?>> gatherer, ResourceIdSet exclusions) {
        if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                gatherer.accept(new OutputResourceTracker(this, exclusions, new AtomicLong(0L), new AtomicLong(0L)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                AtomicLong quantity = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new OutputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit, this.with), exclusions, quantity, new AtomicLong(0L))));
            }
        } else if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                AtomicLong retained = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new OutputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit, this.with), exclusions, new AtomicLong(0L), retained)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                this.resourceId.expand().forEach(rid -> gatherer.accept(new OutputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit, this.with), exclusions, new AtomicLong(0L), new AtomicLong(0L))));
            }
        }
    }

    @Override
    public boolean test(Object obj) {
        if (!this.resourceId.test(obj)) {
            return false;
        }
        Object stack = obj;
        ResourceType<STACK, ITEM, CAP> resourceType = this.resourceId().getResourceType();
        assert (resourceType != null);
        return this.with.test(resourceType, stack);
    }

    @Override
    public String toString() {
        return String.valueOf(this.limit) + " " + String.valueOf(this.resourceId) + (String)(this.with == With.ALWAYS_TRUE ? "" : " WITH " + String.valueOf(this.with));
    }

    public String toStringCondensed(Limit defaults) {
        return (this.limit.toStringCondensed(defaults) + " " + this.resourceId.toStringCondensed() + (String)(this.with == With.ALWAYS_TRUE ? "" : " WITH " + String.valueOf(this.with))).trim();
    }
}

