/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.SetOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public record ResourceComparer<STACK, ITEM, CAP>(ComparisonOperator op, ResourceQuantity quantity, ResourceIdentifier<STACK, ITEM, CAP> res) implements ASTNode
{
    public BoolExpr toBooleanExpression(SetOperator setOp, LabelAccess labelAccess, String sourceCode) {
        return new BoolExpr(context -> {
            ResourceType<STACK, ITEM, Object> type = this.res.getResourceType();
            if (type == null) {
                return false;
            }
            AtomicLong overallCount = new AtomicLong(0L);
            ArrayList<Boolean> satisfiedSet = new ArrayList<Boolean>();
            type.forEachCapability((ProgramContext)context, labelAccess, (label, pos, direction, cap) -> {
                long inThisInv = 0L;
                for (Object stack : type.getStacksInSlots(cap, labelAccess.slots())::iterator) {
                    if (!this.res.test(stack)) continue;
                    inThisInv += type.getAmount(stack);
                    overallCount.addAndGet(type.getAmount(stack));
                }
                satisfiedSet.add(this.op.test(inThisInv, this.quantity.number().value()));
            });
            boolean isOverallSatisfied = this.op.test(overallCount.get(), this.quantity.number().value());
            return setOp.test(isOverallSatisfied, (List<Boolean>)satisfiedSet);
        }, sourceCode);
    }

    @Override
    public String toString() {
        return this.op().getSourceCode() + " " + String.valueOf(this.quantity()) + " " + this.res().toStringCondensed();
    }
}

