/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.LimitedInputSlotObjectPool;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceLimits;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public final class InputStatement
implements IOStatement {
    private final LabelAccess labelAccess;
    private final ResourceLimits resourceLimits;
    private final boolean each;
    @Nullable
    private ArrayDeque<LimitedInputSlot<?, ?, ?>> limitedInputSlotsCache = null;

    public InputStatement(LabelAccess labelAccess, ResourceLimits resourceLimits, boolean each) {
        this.labelAccess = labelAccess;
        this.resourceLimits = resourceLimits;
        this.each = each;
    }

    @Override
    public void tick(ProgramContext context) {
        context.addInput(this);
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_INPUT_STATEMENT.get(this.toString())));
        ProgramBehaviour programBehaviour = context.getBehaviour();
        if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
            SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
            simulation.onInputStatementExecution(context, this);
        }
    }

    public void gatherSlots(ProgramContext context, Consumer<LimitedInputSlot<?, ?, ?>> slotConsumer) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS.get(this.toStringPretty())));
        if (this.limitedInputSlotsCache != null) {
            context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_CACHE_HIT.get()));
            for (LimitedInputSlot<?, ?, ?> slot2 : this.limitedInputSlotsCache) {
                slotConsumer.accept(slot2);
            }
            this.limitedInputSlotsCache.forEach(slotConsumer);
            return;
        }
        context.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_CACHE_MISS.get()));
        this.limitedInputSlotsCache = new ArrayDeque();
        Consumer<LimitedInputSlot<?, ?, ?>> original = slotConsumer;
        slotConsumer = slot -> {
            this.limitedInputSlotsCache.add((LimitedInputSlot<?, ?, ?>)slot);
            original.accept((LimitedInputSlot<?, ?, ?>)slot);
        };
        Set referencedResourceTypes = this.resourceLimits.getReferencedResourceTypes().collect(Collectors.toSet());
        if (!this.each) {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_NOT_EACH.get()));
            List<InputResourceTracker<?, ?, ?>> inputTrackers = this.resourceLimits.createInputTrackers();
            for (ResourceType type : referencedResourceTypes) {
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_FOR_RESOURCE_TYPE.get(type.displayAsCapabilityClass(), type.displayAsCapabilityClass())));
                Consumer<LimitedInputSlot<?, ?, ?>> finalSlotConsumer = slotConsumer;
                type.forEachCapability(context, this.labelAccess, (label, pos, direction, cap) -> this.gatherSlotsForCap(context, type, label, pos, direction, cap, inputTrackers, finalSlotConsumer));
            }
        } else {
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_EACH.get()));
            for (ResourceType type : referencedResourceTypes) {
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_FOR_RESOURCE_TYPE.get(type.displayAsCapabilityClass(), type.displayAsCapabilityClass())));
                Consumer<LimitedInputSlot<?, ?, ?>> finalSlotConsumer = slotConsumer;
                type.forEachCapability(context, this.labelAccess, (label, pos, direction, cap) -> {
                    List<InputResourceTracker<?, ?, ?>> inputTrackers = this.resourceLimits.createInputTrackers();
                    this.gatherSlotsForCap(context, type, label, pos, direction, cap, inputTrackers, finalSlotConsumer);
                });
            }
        }
    }

    public String toString() {
        return "INPUT " + this.resourceLimits.toStringPretty(Limit.MAX_QUANTITY_NO_RETENTION) + " FROM " + (this.each ? "EACH " : "") + String.valueOf(this.labelAccess);
    }

    @Override
    public String toStringPretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("INPUT");
        String rls = this.resourceLimits.toStringPretty(Limit.MAX_QUANTITY_NO_RETENTION);
        if (rls.lines().count() > 1L) {
            sb.append("\n");
            sb.append(rls.lines().map(s -> "  " + s).collect(Collectors.joining("\n")));
            sb.append("\n");
        } else {
            sb.append(" ");
            sb.append(rls);
            sb.append(" ");
        }
        sb.append("FROM ");
        sb.append(this.each ? "EACH " : "");
        sb.append(this.labelAccess);
        return sb.toString();
    }

    @Override
    public LabelAccess labelAccess() {
        return this.labelAccess;
    }

    @Override
    public ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    @Override
    public boolean each() {
        return this.each;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        InputStatement that = (InputStatement)obj;
        return Objects.equals(this.labelAccess, that.labelAccess) && Objects.equals(this.resourceLimits, that.resourceLimits) && this.each == that.each;
    }

    public int hashCode() {
        return Objects.hash(this.labelAccess, this.resourceLimits, this.each);
    }

    public void freeSlots() {
        if (this.limitedInputSlotsCache != null) {
            LimitedInputSlotObjectPool.release(this.limitedInputSlotsCache);
            this.limitedInputSlotsCache = null;
        }
    }

    public void freeSlotsIf(Predicate<LimitedInputSlot<?, ?, ?>> condition) {
        if (this.limitedInputSlotsCache != null) {
            Iterator<LimitedInputSlot<?, ?, ?>> iterator = this.limitedInputSlotsCache.iterator();
            while (iterator.hasNext()) {
                LimitedInputSlot<?, ?, ?> slot = iterator.next();
                if (!condition.test(slot)) continue;
                iterator.remove();
                LimitedInputSlotObjectPool.release(slot);
            }
            if (this.limitedInputSlotsCache.isEmpty()) {
                this.limitedInputSlotsCache = null;
            }
        }
    }

    public void transferSlotsTo(InputStatement other) {
        if (this.limitedInputSlotsCache != null) {
            if (other.limitedInputSlotsCache == null) {
                other.limitedInputSlotsCache = new ArrayDeque();
            }
            other.limitedInputSlotsCache.addAll(this.limitedInputSlotsCache);
        }
        this.limitedInputSlotsCache = null;
    }

    private <STACK, ITEM, CAP> void gatherSlotsForCap(ProgramContext context, ResourceType<STACK, ITEM, CAP> type, Label label, BlockPos pos, Direction direction, CAP capability, List<InputResourceTracker<?, ?, ?>> trackers, Consumer<LimitedInputSlot<?, ?, ?>> acceptor) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_RANGE.get(this.labelAccess.slots())));
        for (int slot = 0; slot < type.getSlots(capability); ++slot) {
            int finalSlot = slot;
            if (this.labelAccess.slots().contains(slot)) {
                Object stack = type.getStackInSlot(capability, slot);
                if (this.shouldCreateSlot(type, stack)) {
                    for (InputResourceTracker<?, ?, ?> tracker : trackers) {
                        if (!tracker.matchesCapabilityType(capability) || !tracker.test(stack)) continue;
                        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_CREATED.get(finalSlot, stack, tracker.toString())));
                        acceptor.accept(LimitedInputSlotObjectPool.acquire(label, pos, direction, slot, capability, tracker, stack));
                    }
                    continue;
                }
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_SHOULD_NOT_CREATE.get(finalSlot, stack)));
                continue;
            }
            context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IO_STATEMENT_GATHER_SLOTS_SLOT_NOT_IN_RANGE.get(finalSlot)));
        }
    }

    private <STACK, ITEM, CAP> boolean shouldCreateSlot(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        return !type.isEmpty(stack);
    }
}

