/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfml.ast.Label;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class LimitedInputSlotObjectPool {
    public static final IdentityHashMap<LimitedInputSlot<?, ?, ?>, Boolean> LEASED = new IdentityHashMap();
    private static LimitedInputSlot[] pool = new LimitedInputSlot[27];
    private static int index = -1;

    public static <STACK, ITEM, CAP> LimitedInputSlot<STACK, ITEM, CAP> acquire(Label label, BlockPos pos, Direction direction, int slot, CAP handler, InputResourceTracker<STACK, ITEM, CAP> tracker, STACK stack) {
        if (index == -1) {
            LimitedInputSlot<STACK, ITEM, CAP> rtn = new LimitedInputSlot<STACK, ITEM, CAP>(label, pos, direction, slot, handler, tracker, stack);
            if (LEASED.put(rtn, true) != null) {
                SFM.LOGGER.warn("new input slot was somehow already leased, this should literally never happen: {}", rtn);
            }
            return rtn;
        }
        LimitedInputSlot obj = pool[index];
        --index;
        obj.init(handler, label, pos, direction, slot, tracker, stack);
        if (LEASED.put(obj, true) != null) {
            SFM.LOGGER.warn("tried to lease input slot a second time: {}", (Object)obj);
        }
        return obj;
    }

    public static void release(LimitedInputSlot<?, ?, ?> slot) {
        if (slot.freed) {
            SFM.LOGGER.warn("Release called on already freed input slot {}", slot);
            return;
        }
        slot.freed = true;
        if (LEASED.remove(slot) == null) {
            SFM.LOGGER.warn("Freed an input slot that wasn't tracked as leased: {}", slot);
        }
        if (index == pool.length - 1) {
            pool = Arrays.copyOf(pool, pool.length * 2);
        }
        LimitedInputSlotObjectPool.pool[++LimitedInputSlotObjectPool.index] = slot;
    }

    public static void release(Collection<LimitedInputSlot<?, ?, ?>> slots) {
        if (index + slots.size() >= pool.length) {
            int slotsFree = pool.length - index - 1;
            int newLength = pool.length + slots.size() - slotsFree;
            pool = Arrays.copyOf(pool, newLength);
        }
        for (LimitedInputSlot<?, ?, ?> slot : slots) {
            if (slot.freed) {
                SFM.LOGGER.warn("Release batch called on already freed input slot {}", slot);
                continue;
            }
            slot.freed = true;
            LimitedInputSlotObjectPool.pool[++LimitedInputSlotObjectPool.index] = slot;
            if (LEASED.remove(slot) != null) continue;
            SFM.LOGGER.warn("Freed in batch an object that wasn't tracked as leased: {}", slot);
        }
    }

    public static void checkInvariant() {
        if (!LEASED.isEmpty()) {
            SFM.LOGGER.warn("Leased objects not released: {}", LEASED);
            LEASED.clear();
        }
    }
}

