/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundOutputInspectionResultsPacket;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.ResourceQuantity;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.antlr.v4.runtime.misc.Pair;

public record ServerboundOutputInspectionRequestPacket(String programString, int outputNodeIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundOutputInspectionRequestPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_output_inspection_request_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundOutputInspectionRequestPacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundOutputInspectionRequestPacket::encode, ServerboundOutputInspectionRequestPacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundOutputInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeUtf(msg.programString, 80960);
        friendlyByteBuf.writeInt(msg.outputNodeIndex());
    }

    public static ServerboundOutputInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundOutputInspectionRequestPacket(friendlyByteBuf.readUtf(80960), friendlyByteBuf.readInt());
    }

    public static void handle(ServerboundOutputInspectionRequestPacket msg, IPayloadContext context) {
        ManagerBlockEntity mbe;
        BlockEntity blockEntity;
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
        if (abstractContainerMenu instanceof ManagerContainerMenu) {
            ManagerContainerMenu mcm = (ManagerContainerMenu)abstractContainerMenu;
            blockEntity = player2.level().getBlockEntity(mcm.MANAGER_POSITION);
            if (!(blockEntity instanceof ManagerBlockEntity)) {
                return;
            }
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ClientboundInputInspectionResultsPacket("This inspection is only available when editing inside a manager."), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        ManagerBlockEntity manager = mbe = (ManagerBlockEntity)blockEntity;
        Program.compile(msg.programString, successProgram -> successProgram.builder().getNodeAtIndex(msg.outputNodeIndex).filter(OutputStatement.class::isInstance).map(OutputStatement.class::cast).ifPresent(outputStatement -> {
            String payload = ServerboundOutputInspectionRequestPacket.getOutputStatementInspectionResultsString(manager, successProgram, outputStatement);
            SFM.LOGGER.debug("Sending output inspection results packet with length {}", (Object)payload.length());
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ClientboundOutputInspectionResultsPacket(payload.toString().strip()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }), failure -> PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ClientboundOutputInspectionResultsPacket("failed to compile program"), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public static String getOutputStatementInspectionResultsString(ManagerBlockEntity manager, Program successProgram, final OutputStatement outputStatement) {
        final StringBuilder payload = new StringBuilder();
        payload.append(outputStatement.toStringPretty()).append("\n");
        payload.append("-- predictions may differ from actual execution results\n");
        final AtomicInteger branchCount = new AtomicInteger(0);
        successProgram.replaceOutputStatement(outputStatement, new OutputStatement(outputStatement.labelAccess(), outputStatement.resourceLimits(), outputStatement.each()){

            @Override
            public void tick(ProgramContext context) {
                ProgramBehaviour programBehaviour = context.getBehaviour();
                if (!(programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour)) {
                    throw new IllegalStateException("Expected behaviour to be SimulateExploreAllPathsProgramBehaviour");
                }
                SimulateExploreAllPathsProgramBehaviour behaviour = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
                StringBuilder branchPayload = new StringBuilder();
                payload.append("-- POSSIBILITY ").append(branchCount.getAndIncrement()).append(" --");
                if (behaviour.getCurrentPath().streamBranches().allMatch(SimulateExploreAllPathsProgramBehaviour.Branch::wasTrue)) {
                    payload.append(" all true\n");
                } else if (behaviour.getCurrentPath().streamBranches().allMatch(Predicate.not(SimulateExploreAllPathsProgramBehaviour.Branch::wasTrue))) {
                    payload.append(" all false\n");
                } else {
                    payload.append('\n');
                }
                behaviour.getCurrentPath().streamBranches().forEach(branch -> {
                    if (branch.wasTrue()) {
                        payload.append(branch.ifStatement().condition().sourceCode()).append(" -- true");
                    } else {
                        payload.append(branch.ifStatement().condition().sourceCode()).append(" -- false");
                    }
                    payload.append("\n");
                });
                payload.append("\n");
                branchPayload.append("-- predicted inputs:\n");
                ArrayList inputSlots = new ArrayList();
                context.getInputs().forEach(inputStatement -> inputStatement.gatherSlots(context, (LimitedInputSlot<?, ?, ?> slot) -> inputSlots.add(new Pair(slot, (Object)inputStatement.labelAccess()))));
                List<InputStatement> inputStatements = inputSlots.stream().map(slot -> SFMUtils.getInputStatementForSlot((LimitedInputSlot)slot.a, (LabelAccess)slot.b)).filter(Optional::isPresent).map(Optional::get).toList();
                if (inputStatements.isEmpty()) {
                    branchPayload.append("none\n-- predicted outputs:\nnone");
                } else {
                    inputStatements.stream().map(InputStatement::toStringPretty).map(x -> x + "\n").forEach(branchPayload::append);
                    branchPayload.append("-- predicted outputs:\n");
                    ResourceLimits resourceLimits = new ResourceLimits(inputSlots.stream().map(slot -> (LimitedInputSlot)slot.a).map(ServerboundOutputInspectionRequestPacket::getSlotResource).toList(), ResourceIdSet.EMPTY);
                    ArrayList condensedResourceLimitList = new ArrayList();
                    for (ResourceLimit<?, ?, ?> resourceLimit : resourceLimits.resourceLimits()) {
                        condensedResourceLimitList.stream().filter(x -> x.resourceId().equals(resourceLimit.resourceId())).findFirst().ifPresentOrElse(found -> {
                            int i = condensedResourceLimitList.indexOf(found);
                            ResourceLimit newLimit = found.withLimit(new Limit(found.limit().quantity().add(resourceLimit.limit().quantity()), ResourceQuantity.MAX_QUANTITY));
                            condensedResourceLimitList.set(i, newLimit);
                        }, () -> condensedResourceLimitList.add(resourceLimit));
                    }
                    ListIterator iter = condensedResourceLimitList.listIterator();
                    while (iter.hasNext()) {
                        ResourceLimit resourceLimit = (ResourceLimit)iter.next();
                        ResourceLocation resourceLimitLocation = ResourceLocation.fromNamespaceAndPath((String)resourceLimit.resourceId().resourceNamespace, (String)resourceLimit.resourceId().resourceName);
                        long accept = outputStatement.resourceLimits().resourceLimits().stream().filter(outputResourceLimit -> outputResourceLimit.resourceId().matchesStack(resourceLimitLocation) && outputStatement.resourceLimits().exclusions().resourceIds().stream().noneMatch(exclusion -> exclusion.matchesStack(resourceLimitLocation))).mapToLong(rl -> rl.limit().quantity().number().value()).max().orElse(0L);
                        if (accept == 0L) {
                            iter.remove();
                            continue;
                        }
                        iter.set(resourceLimit.withLimit(new Limit(new ResourceQuantity(new Number(Long.min(accept, resourceLimit.limit().quantity().number().value())), resourceLimit.limit().quantity().idExpansionBehaviour()), ResourceQuantity.MAX_QUANTITY)));
                    }
                    ResourceLimits condensedResourceLimits = new ResourceLimits(condensedResourceLimitList, ResourceIdSet.EMPTY);
                    if (condensedResourceLimits.resourceLimits().isEmpty()) {
                        branchPayload.append("none\n");
                    } else {
                        branchPayload.append(new OutputStatement(outputStatement.labelAccess(), condensedResourceLimits, outputStatement.each()).toStringPretty());
                    }
                }
                branchPayload.append("\n");
                payload.append(branchPayload.toString().indent(4));
            }
        });
        successProgram.tick(new ProgramContext(successProgram, manager, new SimulateExploreAllPathsProgramBehaviour()));
        return payload.toString().strip();
    }

    private static <STACK, ITEM, CAP> ResourceLimit<STACK, ITEM, CAP> getSlotResource(LimitedInputSlot<STACK, ITEM, CAP> limitedInputSlot) {
        ResourceType resourceType = limitedInputSlot.type;
        ResourceKey resourceTypeResourceKey = SFMResourceTypes.DEFERRED_TYPES.getResourceKey(limitedInputSlot.type).map(x -> x).get();
        STACK stack = limitedInputSlot.peekExtractPotential();
        long amount = limitedInputSlot.type.getAmount(stack);
        amount = Long.min(amount, limitedInputSlot.tracker.getResourceLimit().limit().quantity().number().value());
        long remainingObligation = limitedInputSlot.tracker.getRemainingRetentionObligation();
        amount -= Long.min(amount, remainingObligation);
        Limit amountLimit = new Limit(new ResourceQuantity(new Number(amount), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND), ResourceQuantity.MAX_QUANTITY);
        ResourceLocation stackId = resourceType.getRegistryKey(stack);
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey.location().getNamespace(), resourceTypeResourceKey.location().getPath(), stackId.getNamespace(), stackId.getPath());
        return new ResourceLimit(resourceIdentifier, amountLimit, resourceIdentifier.getDefaultWith());
    }
}

