/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.Level;

public record ServerboundManagerSetLogLevelPacket(int windowId, BlockPos pos, String logLevel) implements CustomPacketPayload
{
    public static final int MAX_LOG_LEVEL_NAME_LENGTH = 64;
    public static final CustomPacketPayload.Type<ServerboundManagerSetLogLevelPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_manager_set_log_level_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundManagerSetLogLevelPacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundManagerSetLogLevelPacket::encode, ServerboundManagerSetLogLevelPacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundManagerSetLogLevelPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeVarInt(msg.windowId());
        friendlyByteBuf.writeBlockPos(msg.pos());
        friendlyByteBuf.writeUtf(msg.logLevel(), 64);
    }

    public static ServerboundManagerSetLogLevelPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundManagerSetLogLevelPacket(friendlyByteBuf.readVarInt(), friendlyByteBuf.readBlockPos(), friendlyByteBuf.readUtf(64));
    }

    public static void handle(ServerboundManagerSetLogLevelPacket msg, IPayloadContext context) {
        SFMPackets.handleServerboundContainerPacket(context, ManagerContainerMenu.class, ManagerBlockEntity.class, msg.pos, msg.windowId, (menu, manager) -> {
            Level logLevelObj = Level.getLevel((String)msg.logLevel());
            manager.setLogLevel(logLevelObj);
            manager.logger.info(x -> x.accept(LocalizationKeys.LOG_LEVEL_UPDATED.get(msg.logLevel())));
            String sender = "UNKNOWN SENDER";
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                sender = player.getName().getString();
            }
            SFM.LOGGER.debug("{} updated manager {} {} log level to {}", (Object)sender, (Object)msg.pos(), (Object)manager.getLevel(), (Object)msg.logLevel());
        });
    }
}

