/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundLabelInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMItems;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundLabelInspectionRequestPacket(String label) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundLabelInspectionRequestPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_label_inspection_request_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundLabelInspectionRequestPacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundLabelInspectionRequestPacket::encode, ServerboundLabelInspectionRequestPacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundLabelInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeUtf(msg.label(), 256);
    }

    public static ServerboundLabelInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundLabelInspectionRequestPacket(friendlyByteBuf.readUtf(256));
    }

    public static void handle(ServerboundLabelInspectionRequestPacket msg, IPayloadContext context) {
        LabelPositionHolder labelPositionHolder;
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        SFM.LOGGER.info("Received label inspection request packet from player {}", (Object)player2.getStringUUID());
        AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
        if (abstractContainerMenu instanceof ManagerContainerMenu) {
            ManagerContainerMenu mcm = (ManagerContainerMenu)abstractContainerMenu;
            SFM.LOGGER.info("Player is using a manager container menu - will append additional info to payload");
            labelPositionHolder = LabelPositionHolder.from(mcm.CONTAINER.getItem(0));
        } else {
            labelPositionHolder = player2.getMainHandItem().is(SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player2.getMainHandItem()) : (player2.getOffhandItem().is(SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player2.getOffhandItem()) : null);
        }
        if (labelPositionHolder == null) {
            SFM.LOGGER.info("Label holder wasn't found - aborting");
            return;
        }
        SFM.LOGGER.info("building payload");
        StringBuilder payload = new StringBuilder();
        payload.append("-- Positions for label \"").append(msg.label()).append("\" --\n");
        payload.append(labelPositionHolder.getPositions(msg.label()).size()).append(" assignments\n");
        payload.append("-- Summary --\n");
        labelPositionHolder.labels().getOrDefault(msg.label(), new HashSet()).forEach(pos -> {
            payload.append(pos.getX()).append(",").append(pos.getY()).append(",").append(pos.getZ());
            if (player2.level().isLoaded(pos)) {
                payload.append(" -- ").append(player2.level().getBlockState(pos).getBlock().getName().getString());
            } else {
                payload.append(" -- chunk not loaded");
            }
            payload.append("\n");
        });
        payload.append("\n\n\n-- Detailed --\n");
        for (BlockPos pos2 : labelPositionHolder.labels().getOrDefault(msg.label(), new HashSet())) {
            if (payload.length() > 20000) {
                payload.append("... (truncated)");
                break;
            }
            payload.append(pos2.getX()).append(",").append(pos2.getY()).append(",").append(pos2.getZ());
            if (player2.level().isLoaded(pos2)) {
                payload.append(" -- ").append(player2.level().getBlockState(pos2).getBlock().getName().getString());
                payload.append("\n").append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults(player2.level(), pos2).indent(1));
            } else {
                payload.append(" -- chunk not loaded");
            }
            payload.append("\n");
        }
        SFM.LOGGER.info("Sending payload response length={} to player {}", (Object)payload.length(), (Object)player2.getStringUUID());
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ClientboundLabelInspectionResultsPacket(payload.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

