/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundLabelGunUpdatePacket(String label, InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundLabelGunUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_label_gun_update_packet"));
    public static final int MAX_LABEL_LENGTH = 80;
    public static final StreamCodec<FriendlyByteBuf, ServerboundLabelGunUpdatePacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundLabelGunUpdatePacket::encode, ServerboundLabelGunUpdatePacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundLabelGunUpdatePacket msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.label, 80);
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundLabelGunUpdatePacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunUpdatePacket(buf.readUtf(80), (InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundLabelGunUpdatePacket msg, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        ItemStack stack = sender.getItemInHand(msg.hand);
        if (stack.getItem() instanceof LabelGunItem) {
            LabelGunItem.setActiveLabel(stack, msg.label);
        }
    }
}

