/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundLabelGunPrunePacket(InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundLabelGunPrunePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_label_gun_prune_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundLabelGunPrunePacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundLabelGunPrunePacket::encode, ServerboundLabelGunPrunePacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundLabelGunPrunePacket msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundLabelGunPrunePacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunPrunePacket((InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundLabelGunPrunePacket msg, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        ItemStack stack = sender.getItemInHand(msg.hand);
        if (stack.getItem() instanceof LabelGunItem) {
            LabelPositionHolder.from(stack).prune().save(stack);
        }
    }
}

