/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundLabelGunClearPacket(InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundLabelGunClearPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_label_gun_clear_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundLabelGunClearPacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundLabelGunClearPacket::encode, ServerboundLabelGunClearPacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundLabelGunClearPacket msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundLabelGunClearPacket decode(FriendlyByteBuf buf) {
        return new ServerboundLabelGunClearPacket((InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundLabelGunClearPacket msg, IPayloadContext context) {
        Player sender = context.player();
        ItemStack stack = sender.getItemInHand(msg.hand);
        if (stack.getItem() instanceof LabelGunItem) {
            LabelPositionHolder.empty().save(stack);
        }
    }
}

