/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundIfStatementInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.Program;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundIfStatementInspectionRequestPacket(String programString, int inputNodeIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundIfStatementInspectionRequestPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_if_statement_inspection_request_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundIfStatementInspectionRequestPacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundIfStatementInspectionRequestPacket::encode, ServerboundIfStatementInspectionRequestPacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundIfStatementInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeUtf(msg.programString, 80960);
        friendlyByteBuf.writeInt(msg.inputNodeIndex());
    }

    public static ServerboundIfStatementInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundIfStatementInspectionRequestPacket(friendlyByteBuf.readUtf(80960), friendlyByteBuf.readInt());
    }

    public static void handle(ServerboundIfStatementInspectionRequestPacket msg, IPayloadContext context) {
        ManagerBlockEntity mbe;
        BlockEntity blockEntity;
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
        if (abstractContainerMenu instanceof ManagerContainerMenu) {
            ManagerContainerMenu mcm = (ManagerContainerMenu)abstractContainerMenu;
            blockEntity = player2.level().getBlockEntity(mcm.MANAGER_POSITION);
            if (!(blockEntity instanceof ManagerBlockEntity)) {
                return;
            }
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ClientboundInputInspectionResultsPacket("This inspection is only available when editing inside a manager."), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        ManagerBlockEntity manager = mbe = (ManagerBlockEntity)blockEntity;
        Program.compile(msg.programString, successProgram -> successProgram.builder().getNodeAtIndex(msg.inputNodeIndex).filter(IfStatement.class::isInstance).map(IfStatement.class::cast).ifPresent(ifStatement -> {
            StringBuilder payload = new StringBuilder();
            payload.append(ifStatement.toStringShort()).append("\n-- peek results --\n");
            ProgramContext programContext = new ProgramContext((Program)successProgram, manager, new SimulateExploreAllPathsProgramBehaviour());
            boolean result = ifStatement.condition().test(programContext);
            payload.append(result ? "TRUE" : "FALSE");
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ClientboundIfStatementInspectionResultsPacket(SFMUtils.truncate(payload.toString(), 2048)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }), failure -> {});
    }
}

