/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.DiskItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundDiskItemSetProgramPacket(String programString, InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundDiskItemSetProgramPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"serverbound_disk_item_set_program_packet"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundDiskItemSetProgramPacket> STREAM_CODEC = StreamCodec.ofMember(ServerboundDiskItemSetProgramPacket::encode, ServerboundDiskItemSetProgramPacket::decode);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(ServerboundDiskItemSetProgramPacket msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.programString, 80960);
        buf.writeEnum((Enum)msg.hand);
    }

    public static ServerboundDiskItemSetProgramPacket decode(FriendlyByteBuf buf) {
        return new ServerboundDiskItemSetProgramPacket(buf.readUtf(80960), (InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public static void handle(ServerboundDiskItemSetProgramPacket msg, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        ItemStack stack = sender.getItemInHand(msg.hand);
        if (stack.getItem() instanceof DiskItem) {
            DiskItem.setProgram(stack, msg.programString);
            DiskItem.compileAndUpdateErrorsAndWarnings(stack, null);
        }
    }
}

