/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundNetworkToolUsePacket;
import ca.teamdman.sfm.common.registry.SFMDataComponents;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetworkToolItem
extends Item {
    public NetworkToolItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext pContext) {
        if (pContext.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundNetworkToolUsePacket(pContext.getClickedPos(), pContext.getClickedFace()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_1.getComponent().withStyle(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_2.getComponent().withStyle(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_3.getComponent(((KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get()).getTranslatedKeyMessage()).withStyle(ChatFormatting.AQUA));
    }

    public void inventoryTick(ItemStack stack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pIsSelected || pLevel.isClientSide || pEntity.tickCount % 20 != 0) {
            return;
        }
        long maxDistance = 128L;
        HashSet cablePositions = new HashSet();
        HashSet capabilityPositions = new HashSet();
        CableNetworkManager.getNetworksInRange(pLevel, pEntity.blockPosition(), 128.0).forEach(net -> {
            net.getCablePositions().forEach(cablePositions::add);
            net.getCapabilityProviderPositions().forEach(capabilityPositions::add);
        });
        stack.set(SFMDataComponents.CABLE_POSITIONS, cablePositions);
        stack.set(SFMDataComponents.CAPABILITY_POSITIONS, capabilityPositions);
    }
}

