/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.handler;

import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="sfm", bus=EventBusSubscriber.Bus.GAME)
public class FallingAnvilHandler {
    @SubscribeEvent
    public static void onLeave(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof FallingBlockEntity)) {
            return;
        }
        FallingBlockEntity fbe = (FallingBlockEntity)entity;
        if (!(fbe.getBlockState().getBlock() instanceof AnvilBlock)) {
            return;
        }
        BlockPos landPosition = fbe.blockPosition();
        Level level = event.getLevel();
        if (!level.isLoaded(landPosition.below())) {
            return;
        }
        Block block = level.getBlockState(landPosition.below()).getBlock();
        if (block == Blocks.IRON_BLOCK) {
            List<ItemEntity> items = FallingAnvilHandler.getItemEntities(level, landPosition);
            FallingAnvilHandler.handleCreatePrintingPressForm(level, items, landPosition);
        } else if (block == Blocks.OBSIDIAN) {
            List<ItemEntity> items = FallingAnvilHandler.getItemEntities(level, landPosition);
            FallingAnvilHandler.handleEnchantedBookCrushing(items);
            FallingAnvilHandler.handleEnchantmentStripping(items, level, landPosition);
        }
    }

    private static void handleEnchantmentStripping(List<ItemEntity> items, Level level, BlockPos landPosition) {
        List<ItemEntity> enchantedItemEntities = items.stream().filter(entity -> !((ItemEnchantments)entity.getItem().getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty()).toList();
        if (enchantedItemEntities.isEmpty()) {
            return;
        }
        List<ItemEntity> bookEntities = items.stream().filter(e -> e.getItem().is(Items.BOOK)).toList();
        int booksAvailable = bookEntities.stream().mapToInt(e -> e.getItem().getCount()).sum();
        for (ItemEntity enchantedEntity : enchantedItemEntities) {
            ItemStack enchantedStack = enchantedEntity.getItem();
            int enchantedStackSize = enchantedStack.getCount();
            ItemEnchantments startingEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)enchantedStack);
            ItemEnchantments.Mutable resultEnchantments = new ItemEnchantments.Mutable(startingEnchantments);
            for (Object2IntMap.Entry entry : startingEnchantments.entrySet()) {
                Holder enchantmentKind = (Holder)entry.getKey();
                int enchantmentLevel = entry.getIntValue();
                if (booksAvailable < enchantedStackSize) break;
                ItemStack resultBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, enchantedStackSize);
                resultBook.enchant(enchantmentKind, enchantmentLevel);
                level.addFreshEntity((Entity)new ItemEntity(level, (double)landPosition.getX(), (double)landPosition.getY(), (double)landPosition.getZ(), resultBook));
                booksAvailable -= enchantedStackSize;
                resultEnchantments.removeIf(e -> e.is(enchantmentKind));
                if (!resultEnchantments.keySet().isEmpty()) continue;
                break;
            }
            EnchantmentHelper.setEnchantments((ItemStack)enchantedStack, (ItemEnchantments)resultEnchantments.toImmutable());
        }
        for (ItemEntity bookEntity : bookEntities) {
            bookEntity.kill();
        }
        while (booksAvailable > 0) {
            int stackSize = Math.min(booksAvailable, 64);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)landPosition.getX(), (double)landPosition.getY(), (double)landPosition.getZ(), new ItemStack((ItemLike)Items.BOOK, stackSize)));
            booksAvailable -= stackSize;
        }
    }

    private static void handleEnchantedBookCrushing(List<ItemEntity> items) {
        items.stream().filter(e -> e.getItem().is(Items.ENCHANTED_BOOK)).forEach(e -> e.setItem(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get(), e.getItem().getCount())));
    }

    private static void handleCreatePrintingPressForm(Level level, List<ItemEntity> items, BlockPos landPosition) {
        List recipes = level.getRecipeManager().getAllRecipesFor(SFMRecipeTypes.PRINTING_PRESS.get());
        boolean didForm = false;
        block0: for (ItemEntity item : items) {
            for (RecipeHolder recipe : recipes) {
                if (!((PrintingPressRecipe)recipe.value()).form().test(item.getItem())) continue;
                didForm = true;
                item.setItem(FormItem.getForm(item.getItem()));
                continue block0;
            }
        }
        if (didForm) {
            level.setBlockAndUpdate(landPosition.below(), Blocks.AIR.defaultBlockState());
        }
    }

    @NotNull
    private static List<ItemEntity> getItemEntities(Level level, BlockPos landPosition) {
        return level.getEntitiesOfClass(ItemEntity.class, new AABB(landPosition)).stream().filter(Entity::isAlive).filter(e -> !e.getItem().isEmpty()).toList();
    }
}

