/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.compat;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ChemicalResourceType;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.DirectionQualifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.api.RelativeSide;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SFMMekanismCompat {
    public static Optional<ResourceType<?, ?, ?>> getResourceType(TransmissionType trans) {
        return switch (trans) {
            case TransmissionType.ITEM -> Optional.of(SFMResourceTypes.ITEM.get());
            case TransmissionType.FLUID -> Optional.of(SFMResourceTypes.FLUID.get());
            case TransmissionType.CHEMICAL -> Optional.of((ResourceType)SFMResourceTypes.DEFERRED_TYPES.get(ResourceLocation.fromNamespaceAndPath((String)"sfm", (String)"chemical")));
            case TransmissionType.ENERGY -> Optional.of(SFMResourceTypes.FORGE_ENERGY.get());
            default -> Optional.empty();
        };
    }

    public static String gatherInspectionResults(BlockEntity blockEntity) {
        if (!(blockEntity instanceof ISideConfiguration)) {
            return "";
        }
        ISideConfiguration sideConfiguration = (ISideConfiguration)blockEntity;
        StringBuilder sb = new StringBuilder();
        sb.append("-- Mekanism stuff\n");
        TileComponentConfig config = sideConfiguration.getConfig();
        for (TransmissionType type : TransmissionType.values()) {
            SFMMekanismCompat.getResourceType(type).flatMap(arg_0 -> SFMResourceTypes.DEFERRED_TYPES.getResourceKey(arg_0)).ifPresent(resourceTypeKey -> {
                ConfigInfo info = config.getConfig(type);
                if (info != null) {
                    Set outputSides = info.getSideConfig().stream().filter(x -> ((DataType)x.getValue()).canOutput()).map(x -> ((RelativeSide)x.getKey()).getDirection(sideConfiguration.getDirection())).collect(Collectors.toSet());
                    if (!outputSides.isEmpty()) {
                        sb.append("-- ").append(LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_MACHINE_OUTPUTS.getString()).append("\n");
                        sb.append("INPUT ").append(resourceTypeKey.location()).append(":: FROM target ");
                        sb.append(outputSides.stream().map(DirectionQualifier::directionToString).collect(Collectors.joining(", ")));
                        sb.append(" SIDE\n");
                    }
                    HashSet<Direction> inputSides = new HashSet<Direction>();
                    for (RelativeSide side : RelativeSide.values()) {
                        DataType dataType = info.getDataType(side);
                        if (dataType != DataType.INPUT && dataType != DataType.INPUT_1 && dataType != DataType.INPUT_2 && dataType != DataType.INPUT_OUTPUT) continue;
                        inputSides.add(side.getDirection(sideConfiguration.getDirection()));
                    }
                    if (!inputSides.isEmpty()) {
                        sb.append("-- ").append(LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_MACHINE_INPUTS.getString()).append("\n");
                        sb.append("OUTPUT ").append(resourceTypeKey.location()).append(":: TO target ");
                        sb.append(inputSides.stream().map(DirectionQualifier::directionToString).collect(Collectors.joining(", ")));
                        sb.append(" SIDE\n");
                    }
                }
            });
        }
        return sb.toString();
    }

    public static void register(DeferredRegister<ResourceType<?, ?, ?>> types) {
        types.register("chemical", ChemicalResourceType::new);
        types.register("gas", ChemicalResourceType::new);
        types.register("infusion", ChemicalResourceType::new);
        types.register("pigment", ChemicalResourceType::new);
        types.register("slurry", ChemicalResourceType::new);
    }
}

