/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.command;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.export.ClientExportHelper;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="sfm")
public class SFMCommand {
    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = Commands.literal((String)"sfm");
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"bust_cable_network_cache").requires(source -> source.hasPermission(0))).executes(ctx -> {
            SFM.LOGGER.info("Busting cable networks - slash command used by {}", (Object)((CommandSourceStack)ctx.getSource()).getTextName());
            CableNetworkManager.clear();
            return 1;
        }));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"show_bad_cable_cache_entries").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)event.getBuildContext())).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
            CableNetworkManager.getBadCableCachePositions((Level)level).forEach(pos -> {
                BlockInput block = BlockStateArgument.getBlock((CommandContext)ctx, (String)"block");
                block.place(level, pos, 3);
            });
            return 1;
        })));
        if (FMLEnvironment.dist.isClient()) {
            command.then(((LiteralArgumentBuilder)Commands.literal((String)"export_info").requires(__ -> true)).then(Commands.argument((String)"includeHidden", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
                boolean includeHidden = BoolArgumentType.getBool((CommandContext)ctx, (String)"includeHidden");
                SFM.LOGGER.info("Exporting info, includeHidden={} - slash command used by {}", (Object)includeHidden, (Object)((CommandSourceStack)ctx.getSource()).getTextName());
                assert (Minecraft.getInstance().player != null);
                new Thread(() -> {
                    try {
                        long start = System.currentTimeMillis();
                        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"Beginning item export"));
                        ClientExportHelper.dumpItems((Player)((CommandSourceStack)ctx.getSource()).getPlayer());
                        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)"Beginning JEI export"));
                        long end = System.currentTimeMillis();
                        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)("Exported data in " + (end - start) + "ms")).withStyle(ChatFormatting.GREEN));
                    }
                    catch (Exception e) {
                        SFM.LOGGER.error("Failed to export item data", (Throwable)e);
                    }
                }).start();
                return 1;
            })));
        }
        event.getDispatcher().register(command);
    }
}

