/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="sfm")
public class CableNetworkManager {
    private static final Map<Level, Long2ObjectMap<CableNetwork>> NETWORKS_BY_CABLE_POSITION = new WeakHashMap<Level, Long2ObjectMap<CableNetwork>>();
    private static final Map<Level, List<CableNetwork>> NETWORKS_BY_LEVEL = new WeakHashMap<Level, List<CableNetwork>>();

    public static Optional<CableNetwork> getOrRegisterNetworkFromManagerPosition(ManagerBlockEntity tile) {
        return CableNetworkManager.getOrRegisterNetworkFromCablePosition(tile.getLevel(), tile.getBlockPos());
    }

    public static Stream<CableNetwork> getNetworksForLevel(Level level) {
        if (level.isClientSide()) {
            return Stream.empty();
        }
        return NETWORKS_BY_LEVEL.getOrDefault(level, Collections.emptyList()).stream();
    }

    public static Stream<CableNetwork> getNetworksInRange(Level level, BlockPos pos, double maxDistance) {
        if (level.isClientSide()) {
            return Stream.empty();
        }
        return CableNetworkManager.getNetworksForLevel(level).filter(net -> net.getCablePositions().anyMatch(cablePos -> cablePos.distSqr((Vec3i)pos) < maxDistance * maxDistance));
    }

    public static void unregisterNetworkForTestingPurposes(CableNetwork network) {
        CableNetworkManager.removeNetwork(network);
    }

    public static void onCablePlaced(Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        CableNetworkManager.getOrRegisterNetworkFromCablePosition(level, pos);
    }

    public static void onCableRemoved(Level level, BlockPos cablePos) {
        CableNetworkManager.getNetworkFromCablePosition(level, cablePos).ifPresent(network -> {
            CableNetworkManager.removeNetwork(network);
            List<CableNetwork> remainingNetworks = network.withoutCable(cablePos);
            remainingNetworks.forEach(CableNetworkManager::addNetwork);
        });
    }

    public static void purgeCableNetworkForManager(ManagerBlockEntity manager) {
        CableNetworkManager.getNetworkFromCablePosition(manager.getLevel(), manager.getBlockPos()).ifPresent(CableNetworkManager::removeNetwork);
    }

    public static Optional<CableNetwork> getOrRegisterNetworkFromCablePosition(Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return Optional.empty();
        }
        Optional<CableNetwork> existing = CableNetworkManager.getNetworkFromCablePosition(level, pos);
        if (existing.isPresent()) {
            return existing;
        }
        if (!CableNetwork.isCable(level, pos)) {
            return Optional.empty();
        }
        Set<CableNetwork> candidates = CableNetworkManager.getNetworksFromCableAdjacentPosition(level, pos);
        if (candidates.isEmpty()) {
            CableNetwork network = new CableNetwork(level);
            network.rebuildNetwork(pos);
            CableNetworkManager.addNetwork(network);
            return Optional.of(network);
        }
        if (candidates.size() == 1) {
            CableNetwork network = candidates.iterator().next();
            network.addCable(pos);
            NETWORKS_BY_CABLE_POSITION.get(level).put(pos.asLong(), (Object)network);
            return Optional.of(network);
        }
        Optional<CableNetwork> result = CableNetworkManager.mergeNetworks(candidates);
        result.ifPresent(net -> net.addCable(pos));
        return result;
    }

    public static List<BlockPos> getBadCableCachePositions(Level level) {
        return CableNetworkManager.getNetworksForLevel(level).flatMap(CableNetwork::getCablePositions).filter(pos -> !(level.getBlockState(pos).getBlock() instanceof ICableBlock)).collect(Collectors.toList());
    }

    public static void clear() {
        NETWORKS_BY_LEVEL.clear();
    }

    private static Optional<CableNetwork> getNetworkFromCablePosition(Level level, BlockPos pos) {
        return Optional.ofNullable((CableNetwork)NETWORKS_BY_CABLE_POSITION.computeIfAbsent(level, k -> new Long2ObjectOpenHashMap()).get(pos.asLong()));
    }

    private static void removeNetwork(CableNetwork network) {
        NETWORKS_BY_LEVEL.getOrDefault(network.getLevel(), Collections.emptyList()).remove(network);
        Long2ObjectMap posMap = NETWORKS_BY_CABLE_POSITION.computeIfAbsent(network.getLevel(), k -> new Long2ObjectOpenHashMap());
        network.CABLE_POSITIONS.forEach(arg_0 -> ((Long2ObjectMap)posMap).remove(arg_0));
    }

    private static void addNetwork(CableNetwork network) {
        NETWORKS_BY_LEVEL.computeIfAbsent(network.getLevel(), k -> new ArrayList()).add(network);
        Long2ObjectMap posMap = NETWORKS_BY_CABLE_POSITION.computeIfAbsent(network.getLevel(), k -> new Long2ObjectOpenHashMap());
        network.CABLE_POSITIONS.forEach(cablePos -> posMap.put(cablePos, (Object)network));
    }

    private static Set<CableNetwork> getNetworksFromCableAdjacentPosition(Level level, BlockPos pos) {
        HashSet<CableNetwork> rtn = new HashSet<CableNetwork>();
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.relative(direction);
            Optional<CableNetwork> network = CableNetworkManager.getNetworkFromCablePosition(level, offset);
            network.ifPresent(rtn::add);
        }
        return rtn;
    }

    private static Optional<CableNetwork> mergeNetworks(Set<CableNetwork> networks) {
        if (networks.isEmpty()) {
            return Optional.empty();
        }
        Iterator<CableNetwork> iterator = networks.iterator();
        CableNetwork main = iterator.next();
        Level level = main.getLevel();
        List<CableNetwork> levelMap = NETWORKS_BY_LEVEL.get(level);
        iterator.forEachRemaining(other -> {
            main.mergeNetwork((CableNetwork)other);
            levelMap.remove(other);
        });
        CableNetworkManager.addNetwork(main);
        return Optional.of(main);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkAccess chunk = event.getChunk();
        CableNetworkManager.purgeChunkFromCableNetworks(level, chunk);
    }

    public static void purgeChunkFromCableNetworks(ServerLevel level, ChunkAccess chunkAccess) {
        CableNetworkManager.getNetworksForLevel((Level)level).forEach(network -> network.bustCacheForChunk(chunkAccess));
    }
}

