/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BatteryBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)10);

    public BatteryBlock() {
        super(BlockBehaviour.Properties.of().strength(5.0f, 6.0f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return SFMBlockEntities.BATTERY_BLOCK_ENTITY.get().create(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL});
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        IEnergyStorage cap = (IEnergyStorage)pLevel.getCapability(Capabilities.EnergyStorage.BLOCK, pPos, (Object)pHitResult.getDirection());
        if (cap != null) {
            if (pPlayer.isShiftKeyDown()) {
                cap.extractEnergy(1000, false);
            } else {
                cap.receiveEnergy(1000, false);
            }
            SFM.LOGGER.info("Energy stored: {}", (Object)cap.getEnergyStored());
        }
        return InteractionResult.SUCCESS;
    }
}

