/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common;

import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SFMConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final Client CLIENT;

    public static <T> T getOrDefault(ModConfigSpec.ConfigValue<T> configValue) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return (T)configValue.getDefault();
        }
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        context.getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    static {
        Pair commonSpecPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue timerTriggerMinimumIntervalInTicks;
        public final ModConfigSpec.IntValue timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO;
        public final ModConfigSpec.IntValue maxIfStatementsInTriggerBeforeSimulationIsntAllowed;

        Common(ModConfigSpec.Builder builder) {
            this.timerTriggerMinimumIntervalInTicks = builder.defineInRange("timerTriggerMinimumIntervalInTicks", 20, 1, Integer.MAX_VALUE);
            this.timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO = builder.defineInRange("timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIOStatementsPresent", 1, 1, Integer.MAX_VALUE);
            this.maxIfStatementsInTriggerBeforeSimulationIsntAllowed = builder.comment("The number of scenarios to check is 2^n where n is the number of if statements in a trigger").defineInRange("maxIfStatementsInTriggerBeforeSimulationIsntAllowed", 10, 0, Integer.MAX_VALUE);
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue showLineNumbers;

        Client(ModConfigSpec.Builder builder) {
            this.showLineNumbers = builder.define("showLineNumbers", false);
        }
    }
}

