/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.item.NetworkToolItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMDataComponents;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="sfm", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ItemWorldRenderer {
    private static final int BUFFER_SIZE = 256;
    private static final RenderType RENDER_TYPE = RenderType.create((String)"sfmlabels", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_BLOCKS, false, false)).setDepthTestState(new RenderStateShard.DepthTestStateShard("always", 519)).setTransparencyState(new RenderStateShard.TransparencyStateShard("src_to_one", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).createCompositeState(true));
    @Nullable
    private static VertexBuffer capabilityProviderVBO;
    @Nullable
    private static VertexBuffer cableVBO;

    @SubscribeEvent
    public static void renderLabelHighlights(RenderLevelStageEvent event) {
        ItemStack networkTool;
        RenderLevelStageEvent.Stage[] stages = new RenderLevelStageEvent.Stage[]{RenderLevelStageEvent.Stage.AFTER_PARTICLES};
        int index = event.getRenderTick() / 30 % stages.length;
        int oldIndex = (event.getRenderTick() - 1) / 30 % stages.length;
        RenderLevelStageEvent.Stage targetStage = stages[index];
        if (index != oldIndex) {
            System.out.println("New stage: " + String.valueOf(targetStage));
        }
        if (event.getStage() != targetStage) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack labelGun = player.getMainHandItem();
        if (!(labelGun.getItem() instanceof LabelGunItem)) {
            labelGun = player.getOffhandItem();
        }
        if (labelGun.getItem() instanceof LabelGunItem) {
            LabelPositionHolder labelPositionHolder = LabelPositionHolder.from(labelGun);
            HashMultimap labelsByPosition = HashMultimap.create();
            labelPositionHolder.forEach((label, pos1) -> labelsByPosition.put(pos1, label));
            PoseStack poseStack = event.getPoseStack();
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderSystem.disableDepthTest();
            poseStack.pushPose();
            poseStack.pushPose();
            poseStack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
            for (Map.Entry entry : labelsByPosition.asMap().entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                Collection labels = (Collection)entry.getValue();
                ItemWorldRenderer.drawLabelsForPos(event, poseStack, camera, pos, (MultiBufferSource)bufferSource, labels);
            }
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.mulPose(camera.rotation().invert());
            poseStack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
            RENDER_TYPE.setupRenderState();
            if (capabilityProviderVBO == null) {
                capabilityProviderVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
                capabilityProviderVBO.bind();
                capabilityProviderVBO.upload(ItemWorldRenderer.createCapabilityProviderVBO());
            } else {
                capabilityProviderVBO.bind();
            }
            for (BlockPos pos : labelsByPosition.keySet()) {
                poseStack.pushPose();
                poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                capabilityProviderVBO.drawWithShader(poseStack.last().pose(), event.getProjectionMatrix(), GameRenderer.getPositionColorShader());
                poseStack.popPose();
            }
            VertexBuffer.unbind();
            RENDER_TYPE.clearRenderState();
            poseStack.popPose();
            bufferSource.endBatch();
            poseStack.popPose();
            RenderSystem.enableDepthTest();
        }
        if (!((networkTool = player.getMainHandItem()).getItem() instanceof NetworkToolItem)) {
            networkTool = player.getOffhandItem();
        }
        if (networkTool.getItem() instanceof NetworkToolItem) {
            Set cablePositions = (Set)networkTool.getOrDefault(SFMDataComponents.CABLE_POSITIONS, new HashSet());
            Set capabilityProviderPositions = (Set)networkTool.getOrDefault(SFMDataComponents.CAPABILITY_POSITIONS, new HashSet());
            PoseStack poseStack = event.getPoseStack();
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderSystem.disableDepthTest();
            poseStack.pushPose();
            poseStack.pushPose();
            poseStack.mulPose(camera.rotation().invert());
            poseStack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
            RENDER_TYPE.setupRenderState();
            if (capabilityProviderVBO == null) {
                capabilityProviderVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
                capabilityProviderVBO.bind();
                capabilityProviderVBO.upload(ItemWorldRenderer.createCapabilityProviderVBO());
            } else {
                capabilityProviderVBO.bind();
            }
            for (BlockPos blockPos : capabilityProviderPositions) {
                poseStack.pushPose();
                poseStack.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
                capabilityProviderVBO.drawWithShader(poseStack.last().pose(), event.getProjectionMatrix(), GameRenderer.getPositionColorShader());
                poseStack.popPose();
            }
            if (cableVBO == null) {
                cableVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
                cableVBO.bind();
                cableVBO.upload(ItemWorldRenderer.createCableVBO());
            } else {
                cableVBO.bind();
            }
            for (BlockPos blockPos : cablePositions) {
                poseStack.pushPose();
                poseStack.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
                cableVBO.drawWithShader(poseStack.last().pose(), event.getProjectionMatrix(), GameRenderer.getPositionColorShader());
                poseStack.popPose();
            }
            VertexBuffer.unbind();
            RENDER_TYPE.clearRenderState();
            poseStack.popPose();
            bufferSource.endBatch();
            poseStack.popPose();
            RenderSystem.enableDepthTest();
        }
    }

    public static MeshData createCapabilityProviderVBO() {
        return ItemWorldRenderer.createShape(100, 0, 255, 100);
    }

    public static MeshData createCableVBO() {
        return ItemWorldRenderer.createShape(100, 255, 0, 100);
    }

    public static MeshData createShape(int r, int g, int b, int a) {
        ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(192);
        BufferBuilder builder = new BufferBuilder(byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(0.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 1.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 1.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 1.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 1.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 0.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 0.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 1.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 0.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 0.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 1.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 1.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        builder.addVertex(1.0f, 0.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 0.0f, 1.0f).setColor(r, g, b, a);
        builder.addVertex(0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        return builder.buildOrThrow();
    }

    private static void drawLabelsForPos(RenderLevelStageEvent event, PoseStack poseStack, Camera camera, BlockPos pos, MultiBufferSource mbs, Collection<String> labels) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        poseStack.mulPose(camera.rotation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Font font = Minecraft.getInstance().font;
        double d = labels.size();
        Objects.requireNonNull(font);
        poseStack.translate(0.0, d * (9.0 + 0.1) / -2.0, 0.0);
        for (String label : labels) {
            font.drawInBatch(label, (float)(-font.width(label)) / 2.0f, 0.0f, -1, false, poseStack.last().pose(), mbs, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            Objects.requireNonNull(font);
            poseStack.translate(0.0, 9.0 + 0.1, 0.0);
        }
        poseStack.popPose();
    }
}

