/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="sfm", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ContainerScreenInspectorHandler {
    private static boolean visible = false;
    @Nullable
    private static AbstractContainerScreen<?> lastScreen = null;
    private static final ExtendedButton exportInspectorButton = new ExtendedButton(5, 50, 100, 20, (Component)LocalizationKeys.CONTAINER_INSPECTOR_SHOW_EXPORTS_BUTTON.getComponent(), button -> {
        BlockEntity lookBlockEntity = ClientStuff.getLookBlockEntity();
        if (lastScreen != null && lookBlockEntity != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundContainerExportsInspectionRequestPacket(ContainerScreenInspectorHandler.lastScreen.getMenu().containerId, lookBlockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    });

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        boolean shouldCapture = Minecraft.getInstance().screen instanceof AbstractContainerScreen;
        if (shouldCapture && visible && exportInspectorButton.clicked(event.getMouseX(), event.getMouseY())) {
            exportInspectorButton.playDownSound(Minecraft.getInstance().getSoundManager());
            exportInspectorButton.onClick(event.getMouseX(), event.getMouseY());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGuiRender(ScreenEvent.Render.Post event) {
        if (!visible) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen acs;
            lastScreen = acs = (AbstractContainerScreen)screen;
            AbstractContainerMenu menu = acs.getMenu();
            int containerSlotCount = 0;
            int inventorySlotCount = 0;
            GuiGraphics graphics = event.getGuiGraphics();
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 350.0f);
            exportInspectorButton.render(graphics, event.getMouseX(), event.getMouseY(), event.getPartialTick());
            for (Slot slot : menu.slots) {
                int colour;
                if (slot.container instanceof Inventory) {
                    colour = ChatFormatting.YELLOW.getColor();
                    ++inventorySlotCount;
                } else {
                    colour = 4095;
                    ++containerSlotCount;
                }
                graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)Integer.toString(slot.getSlotIndex())), acs.getGuiLeft() + slot.x, acs.getGuiTop() + slot.y, colour, false);
            }
            graphics.drawString(Minecraft.getInstance().font, (Component)LocalizationKeys.CONTAINER_INSPECTOR_CONTAINER_SLOT_COUNT.getComponent(Component.literal((String)String.valueOf(containerSlotCount)).withStyle(ChatFormatting.BLUE)), 5, 5, 0xFFFFFF, true);
            graphics.drawString(Minecraft.getInstance().font, (Component)LocalizationKeys.CONTAINER_INSPECTOR_INVENTORY_SLOT_COUNT.getComponent(Component.literal((String)String.valueOf(inventorySlotCount)).withStyle(ChatFormatting.YELLOW)), 5, 25, 0xFFFFFF, true);
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public static void onKeyDown(ScreenEvent.KeyPressed.Pre event) {
        Screen screen;
        KeyMapping toggleKey = (KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get();
        boolean toggleKeyPressed = toggleKey.isActiveAndMatches(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()));
        if (toggleKeyPressed) {
            visible = !visible;
            event.setCanceled(true);
            return;
        }
        KeyMapping activateKey = (KeyMapping)SFMKeyMappings.ITEM_INSPECTOR_KEY.get();
        boolean activateKeyPressed = activateKey.isActiveAndMatches(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()));
        if (activateKeyPressed && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            ItemStack hoveredStack;
            AbstractContainerScreen acs = (AbstractContainerScreen)screen;
            Slot hoveredSlot = acs.hoveredSlot;
            if (hoveredSlot != null && !(hoveredStack = hoveredSlot.getItem()).isEmpty()) {
                ClientStuff.showItemInspectorScreen(hoveredStack);
            }
        }
    }
}

