/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfm.client.gui.EditorUtils;
import ca.teamdman.sfm.client.gui.screen.ExtendedButtonWithTooltip;
import ca.teamdman.sfm.common.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ProgramEditScreen
extends Screen {
    protected final String INITIAL_CONTENT;
    protected final Consumer<String> SAVE_CALLBACK;
    protected MyMultiLineEditBox textarea;
    protected String lastProgram = "";
    protected List<MutableComponent> lastProgramWithSyntaxHighlighting = Collections.emptyList();

    public ProgramEditScreen(String initialContent, Consumer<String> saveCallback) {
        super((Component)LocalizationKeys.PROGRAM_EDIT_SCREEN_TITLE.getComponent());
        this.INITIAL_CONTENT = initialContent;
        this.SAVE_CALLBACK = saveCallback;
    }

    public static MutableComponent substring(MutableComponent component, int start, int end) {
        MutableComponent rtn = Component.empty();
        AtomicInteger seen = new AtomicInteger(0);
        component.visit((style, content) -> {
            int contentEnd;
            int contentStart = Math.max(start - seen.get(), 0);
            if (contentStart < (contentEnd = Math.min(end - seen.get(), content.length()))) {
                rtn.append((Component)Component.literal((String)content.substring(contentStart, contentEnd)).withStyle(style));
            }
            seen.addAndGet(content.length());
            return Optional.empty();
        }, Style.EMPTY);
        return rtn;
    }

    public void scrollToTop() {
        this.textarea.scrollToTop();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        this.textarea = (MyMultiLineEditBox)this.addRenderableWidget((GuiEventListener)new MyMultiLineEditBox());
        this.textarea.setValue(this.INITIAL_CONTENT);
        this.setInitialFocus((GuiEventListener)this.textarea);
        this.addRenderableWidget((GuiEventListener)new ExtendedButtonWithTooltip(this.width / 2 - 200, this.height / 2 - 100 + 195, 16, 20, (Component)Component.literal((String)"#"), button -> this.onToggleLineNumbersButtonClicked(), Tooltip.create((Component)LocalizationKeys.PROGRAM_EDIT_SCREEN_TOGGLE_LINE_NUMBERS_BUTTON_TOOLTIP.getComponent())));
        this.addRenderableWidget((GuiEventListener)new ExtendedButtonWithTooltip(this.width / 2 - 2 - 150, this.height / 2 - 100 + 195, 200, 20, CommonComponents.GUI_DONE, button -> this.saveAndClose(), Tooltip.create((Component)LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP.getComponent())));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 2 + 100, this.height / 2 - 100 + 195, 100, 20, CommonComponents.GUI_CANCEL, button -> this.onClose()));
    }

    private static boolean shouldShowLineNumbers() {
        return (Boolean)SFMConfig.getOrDefault(SFMConfig.CLIENT.showLineNumbers);
    }

    private void onToggleLineNumbersButtonClicked() {
        SFMConfig.CLIENT.showLineNumbers.set((Object)(!ProgramEditScreen.shouldShowLineNumbers() ? 1 : 0));
    }

    public void saveAndClose() {
        this.SAVE_CALLBACK.accept(this.textarea.getValue());
        assert (this.minecraft != null);
        this.minecraft.popGuiLayer();
    }

    public void closeWithoutSaving() {
        assert (this.minecraft != null);
        this.minecraft.popGuiLayer();
    }

    public void onClose() {
        if (!this.INITIAL_CONTENT.equals(this.textarea.getValue())) {
            assert (this.minecraft != null);
            ConfirmScreen exitWithoutSavingConfirmScreen = this.getExitWithoutSavingConfirmScreen();
            this.minecraft.pushGuiLayer((Screen)exitWithoutSavingConfirmScreen);
            exitWithoutSavingConfirmScreen.setDelay(20);
        } else {
            super.onClose();
        }
    }

    @NotNull
    protected ConfirmScreen getSaveConfirmScreen(Runnable onConfirm) {
        return new ConfirmScreen(doSave -> {
            assert (this.minecraft != null);
            this.minecraft.popGuiLayer();
            if (doSave) {
                onConfirm.run();
            }
        }, (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.SAVE_CHANGES_CONFIRM_SCREEN_NO_BUTTON.getComponent());
    }

    @NotNull
    protected ConfirmScreen getExitWithoutSavingConfirmScreen() {
        return new ConfirmScreen(doSave -> {
            assert (this.minecraft != null);
            this.minecraft.popGuiLayer();
            if (doSave) {
                this.closeWithoutSaving();
            }
        }, (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.EXIT_WITHOUT_SAVING_CONFIRM_SCREEN_NO_BUTTON.getComponent());
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.hasControlDown());
            return true;
        }
        return false;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (Screen.hasControlDown() && pCodePoint == ' ') {
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && Screen.hasShiftDown()) {
            this.saveAndClose();
            return true;
        }
        if (pKeyCode == 258) {
            String content = this.textarea.getValue();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            EditorUtils.ManipulationResult result = Screen.hasShiftDown() ? EditorUtils.deindent(content, cursor, selectionCursor) : EditorUtils.indent(content, cursor, selectionCursor);
            this.textarea.setValue(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.hasControlDown());
            return true;
        }
        if (pKeyCode == 47 && Screen.hasControlDown()) {
            String content = this.textarea.getValue();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            EditorUtils.ManipulationResult result = EditorUtils.toggleComments(content, cursor, selectionCursor);
            this.textarea.setValue(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 32 && Screen.hasControlDown()) {
            ProgramTokenContextActions.getContextAction(this.textarea.getValue(), this.textarea.getCursorPosition()).ifPresent(Runnable::run);
            this.textarea.rebuild(false);
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void resize(Minecraft mc, int x, int y) {
        String prev = this.textarea.getValue();
        this.init(mc, x, y);
        super.resize(mc, x, y);
        this.textarea.setValue(prev);
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
    }

    protected class MyMultiLineEditBox
    extends MultiLineEditBox {
        private int frame;

        public MyMultiLineEditBox() {
            super(ProgramEditScreen.this.font, ProgramEditScreen.this.width / 2 - 200, ProgramEditScreen.this.height / 2 - 110, 400, 200, (Component)Component.literal((String)""), (Component)Component.literal((String)""));
            this.frame = 0;
        }

        public void scrollToTop() {
            this.setScrollAmount(0.0);
        }

        public int getCursorPosition() {
            return this.textField.cursor;
        }

        public void setCursorPosition(int cursor) {
            this.textField.cursor = cursor;
        }

        public int getLineNumberWidth() {
            if (ProgramEditScreen.shouldShowLineNumbers()) {
                return this.font.width("000");
            }
            return 0;
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            boolean rtn;
            if (pMouseX >= (double)(this.getX() + 1) && pMouseX <= (double)(this.getX() + this.width - 1)) {
                pMouseX -= (double)this.getLineNumberWidth();
            }
            if (!this.visible) {
                rtn = false;
            } else {
                boolean flag1;
                boolean flag = this.withinContentAreaPoint(pMouseX, pMouseY);
                boolean bl = flag1 = this.scrollbarVisible() && pMouseX >= (double)(this.getX() + this.width) && pMouseX <= (double)(this.getX() + this.width + 8) && pMouseY >= (double)this.getY() && pMouseY < (double)(this.getY() + this.height);
                if (flag1 && pButton == 0) {
                    this.scrolling = true;
                    rtn = true;
                } else {
                    rtn = false;
                }
            }
            if (rtn) {
                return true;
            }
            if (this.withinContentAreaPoint(pMouseX, pMouseY) && pButton == 0) {
                this.textField.setSelecting(Screen.hasShiftDown());
                this.seekCursorScreen(pMouseX, pMouseY);
                return true;
            }
            return false;
        }

        public boolean mouseDragged(double mx, double my, int button, double dx, double dy) {
            if (mx >= (double)(this.getX() + 1) && mx <= (double)(this.getX() + this.width - 1)) {
                mx -= (double)this.getLineNumberWidth();
            }
            return super.mouseDragged(mx, my, button, dx, dy);
        }

        public int getSelectionCursorPosition() {
            return this.textField.selectCursor;
        }

        public void setSelectionCursorPosition(int cursor) {
            this.textField.selectCursor = cursor;
        }

        private void rebuild(boolean showContextActionHints) {
            ProgramEditScreen.this.lastProgram = this.textField.value();
            ProgramEditScreen.this.lastProgramWithSyntaxHighlighting = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(ProgramEditScreen.this.lastProgram, showContextActionHints);
        }

        protected void renderContents(GuiGraphics graphics, int mx, int my, float partialTicks) {
            Matrix4f matrix4f = graphics.pose().last().pose();
            if (!ProgramEditScreen.this.lastProgram.equals(this.textField.value())) {
                this.rebuild(Screen.hasControlDown());
            }
            List<MutableComponent> lines = ProgramEditScreen.this.lastProgramWithSyntaxHighlighting;
            boolean isCursorVisible = this.isFocused() && this.frame++ / 60 % 2 == 0;
            boolean isCursorAtEndOfLine = false;
            int cursorIndex = this.textField.cursor();
            int lineX = this.getX() + this.innerPadding() + this.getLineNumberWidth();
            int lineY = this.getY() + this.innerPadding();
            int charCount = 0;
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.textField.getSelected();
            int selectionStart = selectedRange.beginIndex();
            int selectionEnd = selectedRange.endIndex();
            for (int line = 0; line < lines.size(); ++line) {
                MutableComponent componentColoured = lines.get(line);
                int lineLength = componentColoured.getString().length();
                Objects.requireNonNull(this.font);
                int lineHeight = 9 + (line == 0 ? 2 : 0);
                boolean cursorOnThisLine = isCursorVisible && cursorIndex >= charCount && cursorIndex <= charCount + lineLength;
                MultiBufferSource.BufferSource buffer = graphics.bufferSource();
                if (ProgramEditScreen.shouldShowLineNumbers()) {
                    String lineNumber = String.valueOf(line + 1);
                    this.font.drawInBatch(lineNumber, (float)(lineX - 2 - this.font.width(lineNumber)), (float)lineY, -1, true, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCount + lineLength;
                    cursorY = lineY;
                    cursorX = this.font.drawInBatch((Component)ProgramEditScreen.substring(componentColoured, 0, cursorIndex - charCount), (float)lineX, (float)lineY, -1, true, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0) - 1;
                    this.font.drawInBatch((Component)ProgramEditScreen.substring(componentColoured, cursorIndex - charCount, lineLength), (float)cursorX, (float)lineY, -1, true, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                } else {
                    this.font.drawInBatch((Component)componentColoured, (float)lineX, (float)lineY, -1, true, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                buffer.endBatch();
                if (selectionStart <= charCount + lineLength && selectionEnd > charCount) {
                    int lineSelectionStart = Math.max(selectionStart - charCount, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCount, lineLength);
                    int highlightStartX = this.font.width((FormattedText)ProgramEditScreen.substring(componentColoured, 0, lineSelectionStart));
                    int highlightEndX = this.font.width((FormattedText)ProgramEditScreen.substring(componentColoured, 0, lineSelectionEnd));
                    this.renderHighlight(graphics, lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight);
                }
                lineY += lineHeight;
                charCount += lineLength + 1;
            }
            if (isCursorAtEndOfLine) {
                graphics.drawString(this.font, "_", cursorX, cursorY, -1);
            } else {
                graphics.fill(cursorX, cursorY - 1, cursorX + 1, cursorY + 1 + 9, -1);
            }
        }
    }
}

