/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.client.gui.screen.ProgramEditScreen;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;

public class ExampleEditScreen
extends ProgramEditScreen {
    private final Map<String, String> templates;
    private final String program;

    public ExampleEditScreen(String program, String initialContent, Map<String, String> templates, Consumer<String> saveCallback) {
        super(initialContent, saveCallback);
        this.program = program;
        this.templates = templates;
    }

    public boolean equalsAnyTemplate(String content) {
        return this.templates.values().stream().anyMatch(content::equals);
    }

    @Override
    public void saveAndClose() {
        if (this.program.isBlank() || this.equalsAnyTemplate(this.program)) {
            super.saveAndClose();
        } else {
            assert (this.minecraft != null);
            ConfirmScreen saveConfirmScreen = this.getSaveConfirmScreen(() -> super.saveAndClose());
            this.minecraft.pushGuiLayer((Screen)saveConfirmScreen);
            saveConfirmScreen.setDelay(20);
        }
    }

    @Override
    public void onClose() {
        if (!this.equalsAnyTemplate(this.textarea.getValue())) {
            assert (this.minecraft != null);
            ConfirmScreen exitWithoutSavingConfirmScreen = this.getExitWithoutSavingConfirmScreen();
            this.minecraft.pushGuiLayer((Screen)exitWithoutSavingConfirmScreen);
            exitWithoutSavingConfirmScreen.setDelay(20);
        } else {
            super.onClose();
        }
    }
}

