/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui;

public class EditorUtils {
    private static int findLineStart(String content, int cursorPos) {
        while (cursorPos > 0 && content.charAt(cursorPos - 1) != '\n') {
            --cursorPos;
        }
        return cursorPos;
    }

    private static int findLineEnd(String content, int cursorPos) {
        while (cursorPos < content.length() && content.charAt(cursorPos) != '\n') {
            ++cursorPos;
        }
        return cursorPos;
    }

    public static ManipulationResult indent(String content, int cursorPos, int selectionCursorPos) {
        int lineEnd;
        StringBuilder sb = new StringBuilder(content);
        int lineStart = EditorUtils.findLineStart(content, Math.min(cursorPos, selectionCursorPos));
        if (lineStart == (lineEnd = EditorUtils.findLineEnd(content, Math.max(cursorPos, selectionCursorPos)))) {
            sb.insert(lineStart, "    ");
            if (lineStart <= cursorPos) {
                cursorPos += 4;
            }
            if (lineStart <= selectionCursorPos) {
                selectionCursorPos += 4;
            }
        } else {
            while (lineStart < lineEnd) {
                sb.insert(lineStart, "    ");
                lineEnd += 4;
                if (lineStart < cursorPos) {
                    cursorPos += 4;
                }
                if (lineStart < selectionCursorPos) {
                    selectionCursorPos += 4;
                }
                lineStart = EditorUtils.findLineEnd(sb.toString(), lineStart) + 1;
            }
        }
        return new ManipulationResult(sb.toString(), cursorPos, selectionCursorPos);
    }

    public static ManipulationResult deindent(String content, int cursorPos, int selectionCursorPos) {
        StringBuilder sb = new StringBuilder(content);
        int lineStart = EditorUtils.findLineStart(content, Math.min(cursorPos, selectionCursorPos));
        int lineEnd = EditorUtils.findLineEnd(content, Math.max(cursorPos, selectionCursorPos));
        while (lineStart < lineEnd) {
            for (int i = 0; i < 4 && lineStart < sb.length() && sb.charAt(lineStart) == ' '; ++i) {
                sb.deleteCharAt(lineStart);
                --lineEnd;
                if (lineStart < cursorPos) {
                    --cursorPos;
                }
                if (lineStart >= selectionCursorPos) continue;
                --selectionCursorPos;
            }
            lineStart = EditorUtils.findLineEnd(sb.toString(), lineStart) + 1;
        }
        return new ManipulationResult(sb.toString(), cursorPos, selectionCursorPos);
    }

    public static ManipulationResult toggleComments(String content, int cursorPos, int selectionCursorPos) {
        StringBuilder sb = new StringBuilder(content);
        int lineStart = EditorUtils.findLineStart(content, Math.min(cursorPos, selectionCursorPos));
        int lineEnd = EditorUtils.findLineEnd(content, Math.max(cursorPos, selectionCursorPos));
        boolean allLinesCommented = true;
        while (lineStart < lineEnd) {
            if (lineStart + 2 >= sb.length() || sb.charAt(lineStart) != '-' || sb.charAt(lineStart + 1) != '-') {
                allLinesCommented = false;
                break;
            }
            lineStart = EditorUtils.findLineEnd(sb.toString(), lineStart) + 1;
        }
        lineStart = EditorUtils.findLineStart(content, Math.min(cursorPos, selectionCursorPos));
        lineEnd = EditorUtils.findLineEnd(content, Math.max(cursorPos, selectionCursorPos));
        if (allLinesCommented) {
            while (lineStart < lineEnd) {
                sb.delete(lineStart, lineStart + 2);
                lineEnd -= 2;
                if (lineStart < cursorPos) {
                    cursorPos -= 2;
                }
                if (lineStart < selectionCursorPos) {
                    selectionCursorPos -= 2;
                }
                lineStart = EditorUtils.findLineEnd(sb.toString(), lineStart) + 1;
            }
        } else {
            while (lineStart < lineEnd) {
                sb.insert(lineStart, "--");
                lineEnd += 2;
                if (lineStart <= cursorPos) {
                    cursorPos += 2;
                }
                if (lineStart <= selectionCursorPos) {
                    selectionCursorPos += 2;
                }
                lineStart = EditorUtils.findLineEnd(sb.toString(), lineStart) + 1;
            }
        }
        return new ManipulationResult(sb.toString(), cursorPos, selectionCursorPos);
    }

    public record ManipulationResult(String content, int cursorPosition, int selectionCursorPosition) {
    }
}

