/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import io.netty.buffer.ByteBuf;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import mekanism.api.IDisableableEnum;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyConversion;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.util.EnumUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnitDisplayUtils {
    public static Component getDisplayShort(double value, EnergyUnit unit) {
        return UnitDisplayUtils.getDisplayBase(value, unit, 2, true, true);
    }

    public static Component getDisplay(double temp, TemperatureUnit unit, int decimalPlaces, boolean shift, boolean isShort, boolean spaceBetweenSymbol) {
        return UnitDisplayUtils.getDisplayBase(unit.convertFromK(temp, shift), unit, decimalPlaces, isShort, spaceBetweenSymbol);
    }

    private static Component getDisplayBase(double value, Unit unit, int decimalPlaces, boolean isShort, boolean spaceBetweenSymbol) {
        boolean negative;
        if (value == 0.0) {
            if (isShort) {
                if (spaceBetweenSymbol) {
                    return TextComponentUtil.build(value + " ", unit.getSymbol(false));
                }
                return TextComponentUtil.build(value, unit.getSymbol(false));
            }
            return TextComponentUtil.build(value, unit.getLabel(false));
        }
        boolean singular = Mth.equal((double)value, (double)1.0);
        boolean bl = negative = value < 0.0;
        if (negative) {
            value = Math.abs(value);
        }
        for (int i = 0; i < EnumUtils.MEASUREMENT_UNITS.length; ++i) {
            MeasurementUnit lowerMeasure = EnumUtils.MEASUREMENT_UNITS[i];
            if ((i != 0 || !lowerMeasure.below(value)) && i + 1 < EnumUtils.MEASUREMENT_UNITS.length && (!lowerMeasure.aboveEqual(value) || !EnumUtils.MEASUREMENT_UNITS[i + 1].below(value))) continue;
            return lowerMeasure.getDisplay(value, unit, decimalPlaces, isShort, spaceBetweenSymbol, negative, singular);
        }
        return EnumUtils.MEASUREMENT_UNITS[EnumUtils.MEASUREMENT_UNITS.length - 1].getDisplay(value, unit, decimalPlaces, isShort, spaceBetweenSymbol, negative, singular);
    }

    public static Component getDisplayShort(double value, TemperatureUnit unit) {
        return UnitDisplayUtils.getDisplayShort(value, unit, true);
    }

    public static Component getDisplayShort(double value, TemperatureUnit unit, boolean shift) {
        return UnitDisplayUtils.getDisplayShort(value, unit, shift, 2);
    }

    public static Component getDisplayShort(double value, TemperatureUnit unit, boolean shift, int decimalPlaces) {
        return UnitDisplayUtils.getDisplay(value, unit, decimalPlaces, shift, true, false);
    }

    public static Component getDisplayShort(double value, RadiationUnit unit, int decimalPlaces) {
        return UnitDisplayUtils.getDisplayBase(value, unit, decimalPlaces, true, true);
    }

    public static double roundDecimals(boolean negative, double d, int decimalPlaces) {
        return negative ? UnitDisplayUtils.roundDecimals(-d, decimalPlaces) : UnitDisplayUtils.roundDecimals(d, decimalPlaces);
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        double multiplier = Math.pow(10.0, decimalPlaces);
        long j = (long)(d * multiplier);
        return (double)j / multiplier;
    }

    public static double roundDecimals(double d) {
        return UnitDisplayUtils.roundDecimals(d, 2);
    }

    private static interface Unit {
        public Object getSymbol(boolean var1);

        public ILangEntry getLabel(boolean var1);
    }

    @NothingNullByDefault
    public static enum TemperatureUnit implements IIncrementalEnum<TemperatureUnit>,
    IHasTranslationKey,
    Unit,
    TranslatableEnum
    {
        KELVIN(MekanismLang.TEMPERATURE_KELVIN, MekanismLang.TEMPERATURE_KELVIN_SHORT, "K", "k", 0.0, 1.0),
        CELSIUS(MekanismLang.TEMPERATURE_CELSIUS, MekanismLang.TEMPERATURE_CELSIUS_SHORT, "\u00b0C", "c", 273.15, 1.0),
        RANKINE(MekanismLang.TEMPERATURE_RANKINE, MekanismLang.TEMPERATURE_RANKINE_SHORT, "R", "r", 0.0, 1.8),
        FAHRENHEIT(MekanismLang.TEMPERATURE_FAHRENHEIT, MekanismLang.TEMPERATURE_FAHRENHEIT_SHORT, "\u00b0F", "f", 459.67, 1.8),
        AMBIENT(MekanismLang.TEMPERATURE_AMBIENT, MekanismLang.TEMPERATURE_AMBIENT_SHORT, "+STP", "stp", 300.0, 1.0);

        public static final IntFunction<TemperatureUnit> BY_ID;
        public static final StreamCodec<ByteBuf, TemperatureUnit> STREAM_CODEC;
        private final ILangEntry langEntry;
        private final ILangEntry shortName;
        private final String symbol;
        private final String tabName;
        public final double zeroOffset;
        public final double intervalSize;

        private TemperatureUnit(ILangEntry langEntry, ILangEntry shortName, String symbol, String tabName, double offset, double size) {
            this.langEntry = langEntry;
            this.shortName = shortName;
            this.symbol = symbol;
            this.tabName = tabName;
            this.zeroOffset = offset;
            this.intervalSize = size;
        }

        public double convertFromK(double temp, boolean shift) {
            return temp * this.intervalSize - (shift ? this.zeroOffset : 0.0);
        }

        public double convertToK(double temp, boolean shift) {
            return (temp + (shift ? this.zeroOffset : 0.0)) / this.intervalSize;
        }

        @Override
        public String getSymbol(boolean singular) {
            return this.symbol;
        }

        @Override
        public ILangEntry getLabel(boolean singular) {
            return this.langEntry;
        }

        @NotNull
        public Component getTranslatedName() {
            return this.getLabel(false).translate();
        }

        @Override
        public String getTranslationKey() {
            return this.shortName.getTranslationKey();
        }

        public String getTabName() {
            return this.tabName;
        }

        @Override
        public TemperatureUnit byIndex(int index) {
            return BY_ID.apply(index);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])TemperatureUnit.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static enum MeasurementUnit {
        FEMTO("Femto", "f", 1.0E-15),
        PICO("Pico", "p", 1.0E-12),
        NANO("Nano", "n", 1.0E-9),
        MICRO("Micro", "\u00b5", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        BASE("", "", 1.0),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0),
        GIGA("Giga", "G", 1.0E9),
        TERA("Tera", "T", 1.0E12),
        PETA("Peta", "P", 1.0E15),
        EXA("Exa", "E", 1.0E18),
        ZETTA("Zetta", "Z", 1.0E21),
        YOTTA("Yotta", "Y", 1.0E24);

        private final String name;
        private final String symbol;
        private final double value;

        private MeasurementUnit(String name, String symbol, double value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean isShort) {
            if (isShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double d) {
            return d / this.value;
        }

        public boolean aboveEqual(double d) {
            return d >= this.value;
        }

        public boolean below(double d) {
            return d < this.value;
        }

        private Component getDisplay(double value, Unit unit, int decimalPlaces, boolean isShort, boolean spaceBetweenSymbol, boolean negative, boolean singular) {
            double rounded = UnitDisplayUtils.roundDecimals(negative, this.process(value), decimalPlaces);
            Object name = this.getName(isShort);
            if (spaceBetweenSymbol || !isShort) {
                name = " " + (String)name;
            }
            if (isShort) {
                return TextComponentUtil.build(rounded + (String)name, unit.getSymbol(singular));
            }
            return TextComponentUtil.build(rounded + (String)name, unit.getLabel(singular));
        }
    }

    public static enum RadiationUnit implements Unit
    {
        SV("Sv"),
        SVH("Sv/h");

        private final String symbol;

        private RadiationUnit(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public String getSymbol(boolean singular) {
            return this.symbol;
        }

        @Override
        public ILangEntry getLabel(boolean singular) {
            return MekanismLang.ERROR;
        }
    }

    @NothingNullByDefault
    public static enum EnergyUnit implements IDisableableEnum<EnergyUnit>,
    IEnergyConversion,
    Unit,
    IHasTranslationKey,
    TranslatableEnum
    {
        JOULES((ILangEntry)MekanismLang.ENERGY_JOULES, (ILangEntry)MekanismLang.ENERGY_JOULES_PLURAL, (ILangEntry)MekanismLang.ENERGY_JOULES_SHORT, "j", null, ConstantPredicates.ALWAYS_TRUE){

            @Override
            public double getConversion() {
                return 1.0;
            }

            @Override
            public boolean isOneToOne() {
                return true;
            }

            @Override
            public long convertFrom(long joules) {
                return joules;
            }

            @Override
            public long convertTo(long joules) {
                return joules;
            }
        }
        ,
        FORGE_ENERGY(MekanismLang.ENERGY_FORGE, MekanismLang.ENERGY_FORGE, MekanismLang.ENERGY_FORGE_SHORT, "fe", () -> MekanismConfig.general.forgeConversionRate, () -> !MekanismConfig.general.blacklistForge.getOrDefault());

        public static final IntFunction<EnergyUnit> BY_ID;
        public static final StreamCodec<ByteBuf, EnergyUnit> STREAM_CODEC;
        private final Supplier<CachedDoubleValue> conversion;
        private final BooleanSupplier checkEnabled;
        private final ILangEntry singularLangEntry;
        private final ILangEntry pluralLangEntry;
        private final ILangEntry shortLangEntry;
        private final String tabName;

        private EnergyUnit(ILangEntry singularLangEntry, ILangEntry pluralLangEntry, @Nullable ILangEntry shortLangEntry, String tabName, Supplier<CachedDoubleValue> conversionRate, BooleanSupplier checkEnabled) {
            this.singularLangEntry = singularLangEntry;
            this.pluralLangEntry = pluralLangEntry;
            this.shortLangEntry = shortLangEntry;
            this.checkEnabled = checkEnabled;
            this.tabName = tabName;
            this.conversion = conversionRate;
        }

        @Override
        public ILangEntry getSymbol(boolean singular) {
            return this.shortLangEntry;
        }

        @Override
        public ILangEntry getLabel(boolean singular) {
            return singular ? this.singularLangEntry : this.pluralLangEntry;
        }

        @Override
        public double getConversion() {
            return this.conversion.get().getOrDefault();
        }

        @Override
        public String getTranslationKey() {
            return this.shortLangEntry.getTranslationKey();
        }

        @NotNull
        public Component getTranslatedName() {
            return this.getLabel(false).translate();
        }

        @Override
        @NotNull
        public EnergyUnit byIndex(int index) {
            return BY_ID.apply(index);
        }

        public String getTabName() {
            return this.tabName;
        }

        @Override
        public boolean isEnabled() {
            return this.checkEnabled.getAsBoolean();
        }

        public static EnergyUnit getConfigured() {
            EnergyUnit type = (EnergyUnit)MekanismConfig.common.energyUnit.get();
            return type.isEnabled() ? type : JOULES;
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])EnergyUnit.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

