/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.multiblock.TileEntitySPSCasing;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntitySPSPort
extends TileEntitySPSCasing {
    private final Map<Direction, BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> chemicalCapabilityCaches = new EnumMap<Direction, BlockCapabilityCache<IChemicalHandler, Direction>>(Direction.class);
    private MachineEnergyContainer<TileEntitySPSPort> energyContainer;

    public TileEntitySPSPort(BlockPos pos, BlockState state) {
        super(MekanismBlocks.SPS_PORT, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Override
    protected boolean onUpdateServer(SPSMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer(multiblock);
        if (multiblock.isFormed() && !this.energyContainer.isEmpty() && multiblock.canSupplyCoilEnergy(this)) {
            multiblock.supplyCoilEnergy(this, this.energyContainer.extract(this.energyContainer.getEnergy(), Action.EXECUTE, AutomationType.INTERNAL));
        }
        return needsPacket;
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this.facingSupplier);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        return side -> ((SPSMultiblockData)this.getMultiblock()).getChemicalTanks(side);
    }

    @Override
    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.CHEMICAL) {
            return false;
        }
        return super.persists(type);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addChemicalTargetCapability(List<MultiblockData.CapabilityOutputTarget<IChemicalHandler>> outputTargets, Direction side) {
        @Nullable Object cache = this.chemicalCapabilityCaches.get(side);
        if (cache == null) {
            cache = Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.relative(side), side.getOpposite());
            this.chemicalCapabilityCaches.put(side, (BlockCapabilityCache<IChemicalHandler, Direction>)cache);
        }
        outputTargets.add(new MultiblockData.CapabilityOutputTarget<IChemicalHandler>((BlockCapabilityCache<IChemicalHandler, Direction>)cache, this::getActive));
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.displayClientMessage((Component)MekanismLang.SPS_PORT_MODE.translateColored(EnumColor.GRAY, BooleanStateDisplay.InputOutput.of(oldMode, true)), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int getRedstoneLevel() {
        return ((SPSMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input.")
    boolean getMode() {
        return this.getActive();
    }

    @ComputerMethod(methodDescription="true -> output, false -> input.")
    void setMode(boolean output) {
        this.setActive(output);
    }
}

