/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mekanism.api.Chunk3D;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketUpdateTile;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.interfaces.ITileWrapper;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityUpdateable
extends BlockEntity
implements ITileWrapper {
    @Nullable
    private GlobalPos cachedCoord;
    private boolean cacheCoord;
    private long lastSave;
    private final long worldPositionLong;

    public TileEntityUpdateable(TileEntityTypeRegistryObject<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)type.get(), pos, state);
        this.worldPositionLong = pos.asLong();
    }

    public List<DataComponentType<?>> getRemapEntries() {
        return new ArrayList(this.collectComponents().keySet());
    }

    public void onAdded() {
    }

    protected void cacheCoord() {
        this.cacheCoord = true;
        this.updateCoord();
    }

    @NotNull
    protected Level getWorldNN() {
        return Objects.requireNonNull(this.getLevel(), "getWorldNN called before world set");
    }

    public boolean isRemote() {
        return this.getWorldNN().isClientSide();
    }

    public void blockRemoved() {
    }

    public void markDirtyComparator() {
    }

    public final void setChanged() {
        this.setChanged(true);
    }

    public final void markForSave() {
        this.setChanged(false);
    }

    protected void setChanged(boolean updateComparator) {
        if (this.level != null) {
            long time = this.level.getGameTime();
            if (this.lastSave != time) {
                WorldUtils.markChunkDirty(this.level, this.worldPosition);
                this.lastSave = time;
            }
            if (updateComparator && !this.isRemote()) {
                this.markDirtyComparator();
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        BlockEntity.ComponentHelper.COMPONENTS_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(p_337987_ -> Mekanism.logger.warn("Failed to load components: {}", p_337987_)).ifPresent(arg_0 -> ((TileEntityUpdateable)this).setComponents(arg_0));
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.getReducedUpdateTag(provider);
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        return super.getUpdateTag(provider);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = pkt.getTag();
        if (!tag.isEmpty()) {
            this.handleUpdatePacket(tag, provider);
        }
    }

    public void handleUpdatePacket(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.handleUpdateTag(tag, provider);
    }

    public void sendUpdatePacket() {
        this.sendUpdatePacket(this);
    }

    public void sendUpdatePacket(BlockEntity tracking) {
        if (this.isRemote()) {
            Mekanism.logger.warn("Update packet call requested from client side", (Throwable)new IllegalStateException());
        } else if (this.isRemoved()) {
            Mekanism.logger.warn("Update packet call requested for removed tile", (Throwable)new IllegalStateException());
        } else if (PacketUtils.hasPlayersTracking((ServerLevel)tracking.getLevel(), tracking.getBlockPos())) {
            PacketUtils.sendToAllTracking(new PacketUpdateTile(this), tracking);
        }
    }

    protected void updateModelData() {
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.updateCoord();
    }

    public void setLevel(@NotNull Level world) {
        super.setLevel(world);
        this.updateCoord();
    }

    private void updateCoord() {
        if (this.cacheCoord && this.level != null) {
            this.cachedCoord = GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition);
        }
    }

    @Override
    public GlobalPos getTileGlobalPos() {
        return this.cacheCoord && this.cachedCoord != null ? this.cachedCoord : ITileWrapper.super.getTileGlobalPos();
    }

    public long getWorldPositionLong() {
        return this.worldPositionLong;
    }

    @Override
    public Chunk3D getTileChunk() {
        if (this.cacheCoord && this.cachedCoord != null) {
            return new Chunk3D(this.cachedCoord);
        }
        BlockPos pos = this.getBlockPos();
        return new Chunk3D((ResourceKey<Level>)this.getLevel().dimension(), SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }
}

